/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.lf5.viewer.categoryexplorer;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.jetbrains.jet.internal.org.apache.log4j.lf5.LogRecord;
import org.jetbrains.jet.internal.org.apache.log4j.lf5.LogRecordFilter;
import org.jetbrains.jet.internal.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerModel;
import org.jetbrains.jet.internal.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.jetbrains.jet.internal.org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;

public class CategoryExplorerLogRecordFilter
implements LogRecordFilter {
    protected CategoryExplorerModel _model;

    public CategoryExplorerLogRecordFilter(CategoryExplorerModel model) {
        this._model = model;
    }

    @Override
    public boolean passes(LogRecord record) {
        CategoryPath path = new CategoryPath(record.getCategory());
        return this._model.isCategoryPathActive(path);
    }

    public void reset() {
        this.resetAllNodes();
    }

    protected void resetAllNodes() {
        Enumeration<TreeNode> nodes = this._model.getRootCategoryNode().depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            CategoryNode current = (CategoryNode)nodes.nextElement();
            current.resetNumberOfContainedRecords();
            this._model.nodeChanged(current);
        }
    }
}

