/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.jmx;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jetbrains.jet.internal.org.apache.log4j.Appender;
import org.jetbrains.jet.internal.org.apache.log4j.Level;
import org.jetbrains.jet.internal.org.apache.log4j.Logger;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.OptionConverter;
import org.jetbrains.jet.internal.org.apache.log4j.jmx.AbstractDynamicMBean;
import org.jetbrains.jet.internal.org.apache.log4j.jmx.AppenderDynamicMBean;

public class LoggerDynamicMBean
extends AbstractDynamicMBean
implements NotificationListener {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[1];
    private Vector dAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private String dDescription = "This MBean acts as a management facade for a org.apache.log4j.Logger instance.";
    private static Logger cat = Logger.getLogger(class$org$apache$log4j$jmx$LoggerDynamicMBean == null ? (class$org$apache$log4j$jmx$LoggerDynamicMBean = LoggerDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.jmx.LoggerDynamicMBean")) : class$org$apache$log4j$jmx$LoggerDynamicMBean);
    private Logger logger;
    static /* synthetic */ Class class$org$apache$log4j$jmx$LoggerDynamicMBean;
    static /* synthetic */ Class class$org$apache$log4j$Appender;

    public LoggerDynamicMBean(Logger logger) {
        this.logger = logger;
        this.buildDynamicMBeanInfo();
    }

    @Override
    public void handleNotification(Notification notification, Object object) {
        cat.debug(new StringBuffer().append("Received notification: ").append(notification.getType()).toString());
        this.registerAppenderMBean((Appender)notification.getUserData());
    }

    private void buildDynamicMBeanInfo() {
        Constructor<?>[] constructorArray = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("HierarchyDynamicMBean(): Constructs a HierarchyDynamicMBean instance", constructorArray[0]);
        this.dAttributes.add(new MBeanAttributeInfo("name", "java.lang.String", "The name of this Logger.", true, false, false));
        this.dAttributes.add(new MBeanAttributeInfo("priority", "java.lang.String", "The priority of this logger.", true, true, false));
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("class name", "java.lang.String", "add an appender to this logger"), new MBeanParameterInfo("appender name", "java.lang.String", "name of the appender")};
        this.dOperations[0] = new MBeanOperationInfo("addAppender", "addAppender(): add an appender", mBeanParameterInfoArray, "void", 1);
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[this.dAttributes.size()];
        this.dAttributes.toArray(mBeanAttributeInfoArray);
        MBeanInfo mBeanInfo = new MBeanInfo(this.dClassName, this.dDescription, mBeanAttributeInfoArray, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
        return mBeanInfo;
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string.equals("addAppender")) {
            this.addAppender((String)objectArray[0], (String)objectArray[1]);
            return "Hello world.";
        }
        return null;
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), new StringBuffer().append("Cannot invoke a getter of ").append(this.dClassName).append(" with null attribute name").toString());
        }
        if (string.equals("name")) {
            return this.logger.getName();
        }
        if (string.equals("priority")) {
            Level level = this.logger.getLevel();
            if (level == null) {
                return null;
            }
            return level.toString();
        }
        if (string.startsWith("appender=")) {
            try {
                return new ObjectName(new StringBuffer().append("log4j:").append(string).toString());
            }
            catch (Exception exception) {
                cat.error(new StringBuffer().append("Could not create ObjectName").append(string).toString());
            }
        }
        throw new AttributeNotFoundException(new StringBuffer().append("Cannot find ").append(string).append(" attribute in ").append(this.dClassName).toString());
    }

    void addAppender(String string, String string2) {
        cat.debug(new StringBuffer().append("addAppender called with ").append(string).append(", ").append(string2).toString());
        Appender appender = (Appender)OptionConverter.instantiateByClassName(string, class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = LoggerDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.Appender")) : class$org$apache$log4j$Appender, null);
        appender.setName(string2);
        this.logger.addAppender(appender);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), new StringBuffer().append("Cannot invoke a setter of ").append(this.dClassName).append(" with null attribute").toString());
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), new StringBuffer().append("Cannot invoke the setter of ").append(this.dClassName).append(" with null attribute name").toString());
        }
        if (string.equals("priority")) {
            if (object instanceof String) {
                String string2 = (String)object;
                Level level = this.logger.getLevel();
                level = string2.equalsIgnoreCase("NULL") ? null : OptionConverter.toLevel(string2, level);
                this.logger.setPriority(level);
            }
        } else {
            throw new AttributeNotFoundException(new StringBuffer().append("Attribute ").append(string).append(" not found in ").append(this.getClass().getName()).toString());
        }
    }

    void appenderMBeanRegistration() {
        Enumeration enumeration = this.logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            this.registerAppenderMBean(appender);
        }
    }

    void registerAppenderMBean(Appender appender) {
        String string = appender.getName();
        cat.debug(new StringBuffer().append("Adding AppenderMBean for appender named ").append(string).toString());
        ObjectName objectName = null;
        try {
            AppenderDynamicMBean appenderDynamicMBean = new AppenderDynamicMBean(appender);
            objectName = new ObjectName("log4j", "appender", string);
            this.server.registerMBean(appenderDynamicMBean, objectName);
            this.dAttributes.add(new MBeanAttributeInfo(new StringBuffer().append("appender=").append(string).toString(), "javax.management.ObjectName", new StringBuffer().append("The ").append(string).append(" appender.").toString(), true, true, false));
        }
        catch (Exception exception) {
            cat.error(new StringBuffer().append("Could not add appenderMBean for [").append(string).append("].").toString(), exception);
        }
    }

    @Override
    public void postRegister(Boolean bl) {
        this.appenderMBeanRegistration();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

