/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.jmx;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jetbrains.jet.internal.org.apache.log4j.Layout;
import org.jetbrains.jet.internal.org.apache.log4j.Level;
import org.jetbrains.jet.internal.org.apache.log4j.Logger;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.OptionConverter;
import org.jetbrains.jet.internal.org.apache.log4j.jmx.AbstractDynamicMBean;
import org.jetbrains.jet.internal.org.apache.log4j.jmx.MethodUnion;
import org.jetbrains.jet.internal.org.apache.log4j.spi.OptionHandler;

public class LayoutDynamicMBean
extends AbstractDynamicMBean {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private Vector dAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private Hashtable dynamicProps = new Hashtable(5);
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[1];
    private String dDescription = "This MBean acts as a management facade for log4j layouts.";
    private static Logger cat = Logger.getLogger(class$org$apache$log4j$jmx$LayoutDynamicMBean == null ? (class$org$apache$log4j$jmx$LayoutDynamicMBean = LayoutDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.jmx.LayoutDynamicMBean")) : class$org$apache$log4j$jmx$LayoutDynamicMBean);
    private Layout layout;
    static /* synthetic */ Class class$org$apache$log4j$jmx$LayoutDynamicMBean;
    static /* synthetic */ Class class$org$apache$log4j$Level;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Priority;

    public LayoutDynamicMBean(Layout layout) throws IntrospectionException {
        this.layout = layout;
        this.buildDynamicMBeanInfo();
    }

    private void buildDynamicMBeanInfo() throws IntrospectionException {
        MBeanParameterInfo[] mBeanParameterInfoArray;
        Constructor<?>[] constructorArray = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("LayoutDynamicMBean(): Constructs a LayoutDynamicMBean instance", constructorArray[0]);
        BeanInfo beanInfo = Introspector.getBeanInfo(this.layout.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz;
            mBeanParameterInfoArray = propertyDescriptorArray[n2].getName();
            Method method = propertyDescriptorArray[n2].getReadMethod();
            Method method2 = propertyDescriptorArray[n2].getWriteMethod();
            if (method != null && this.isSupportedType(clazz = method.getReturnType())) {
                String string = clazz.isAssignableFrom(class$org$apache$log4j$Level == null ? LayoutDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.Level") : class$org$apache$log4j$Level) ? "java.lang.String" : clazz.getName();
                this.dAttributes.add(new MBeanAttributeInfo((String)mBeanParameterInfoArray, string, "Dynamic", true, method2 != null, false));
                this.dynamicProps.put(mBeanParameterInfoArray, new MethodUnion(method, method2));
            }
            ++n2;
        }
        mBeanParameterInfoArray = new MBeanParameterInfo[]{};
        this.dOperations[0] = new MBeanOperationInfo("activateOptions", "activateOptions(): add an layout", mBeanParameterInfoArray, "void", 1);
    }

    private boolean isSupportedType(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = LayoutDynamicMBean.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        return clazz.isAssignableFrom(class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = LayoutDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.Level")) : class$org$apache$log4j$Level);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        cat.debug("getMBeanInfo called.");
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[this.dAttributes.size()];
        this.dAttributes.toArray(mBeanAttributeInfoArray);
        return new MBeanInfo(this.dClassName, this.dDescription, mBeanAttributeInfoArray, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string.equals("activateOptions") && this.layout instanceof OptionHandler) {
            Layout layout = this.layout;
            layout.activateOptions();
            return "Options activated.";
        }
        return null;
    }

    @Override
    protected Logger getLogger() {
        return cat;
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), new StringBuffer().append("Cannot invoke a getter of ").append(this.dClassName).append(" with null attribute name").toString());
        }
        MethodUnion methodUnion = (MethodUnion)this.dynamicProps.get(string);
        cat.debug(new StringBuffer().append("----name=").append(string).append(", mu=").append(methodUnion).toString());
        if (methodUnion != null && methodUnion.readMethod != null) {
            try {
                return methodUnion.readMethod.invoke((Object)this.layout, null);
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new AttributeNotFoundException(new StringBuffer().append("Cannot find ").append(string).append(" attribute in ").append(this.dClassName).toString());
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), new StringBuffer().append("Cannot invoke a setter of ").append(this.dClassName).append(" with null attribute").toString());
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), new StringBuffer().append("Cannot invoke the setter of ").append(this.dClassName).append(" with null attribute name").toString());
        }
        MethodUnion methodUnion = (MethodUnion)this.dynamicProps.get(string);
        if (methodUnion != null && methodUnion.writeMethod != null) {
            Object[] objectArray = new Object[1];
            Class<?>[] classArray = methodUnion.writeMethod.getParameterTypes();
            if (classArray[0] == (class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = LayoutDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.Priority")) : class$org$apache$log4j$Priority)) {
                object = OptionConverter.toLevel((String)object, (Level)this.getAttribute(string));
            }
            objectArray[0] = object;
            try {
                methodUnion.writeMethod.invoke((Object)this.layout, objectArray);
            }
            catch (Exception exception) {
                cat.error("FIXME", exception);
            }
        } else {
            throw new AttributeNotFoundException(new StringBuffer().append("Attribute ").append(string).append(" not found in ").append(this.getClass().getName()).toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

