/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.jmx;

import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jetbrains.jet.internal.org.apache.log4j.Appender;
import org.jetbrains.jet.internal.org.apache.log4j.Category;
import org.jetbrains.jet.internal.org.apache.log4j.Level;
import org.jetbrains.jet.internal.org.apache.log4j.LogManager;
import org.jetbrains.jet.internal.org.apache.log4j.Logger;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.OptionConverter;
import org.jetbrains.jet.internal.org.apache.log4j.jmx.AbstractDynamicMBean;
import org.jetbrains.jet.internal.org.apache.log4j.jmx.LoggerDynamicMBean;
import org.jetbrains.jet.internal.org.apache.log4j.spi.HierarchyEventListener;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggerRepository;

public class HierarchyDynamicMBean
extends AbstractDynamicMBean
implements NotificationBroadcaster,
HierarchyEventListener {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[1];
    private Vector vAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private String dDescription = "This MBean acts as a management facade for org.apache.log4j.Hierarchy.";
    private NotificationBroadcasterSupport nbs = new NotificationBroadcasterSupport();
    private LoggerRepository hierarchy = LogManager.getLoggerRepository();
    private static Logger log = Logger.getLogger(class$org$apache$log4j$jmx$HierarchyDynamicMBean == null ? (class$org$apache$log4j$jmx$HierarchyDynamicMBean = HierarchyDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.jmx.HierarchyDynamicMBean")) : class$org$apache$log4j$jmx$HierarchyDynamicMBean);
    static /* synthetic */ Class class$org$apache$log4j$jmx$HierarchyDynamicMBean;

    public HierarchyDynamicMBean() {
        this.buildDynamicMBeanInfo();
    }

    private void buildDynamicMBeanInfo() {
        Constructor<?>[] constructorArray = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("HierarchyDynamicMBean(): Constructs a HierarchyDynamicMBean instance", constructorArray[0]);
        this.vAttributes.add(new MBeanAttributeInfo("threshold", "java.lang.String", "The \"threshold\" state of the hiearchy.", true, true, false));
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("name", "java.lang.String", "Create a logger MBean")};
        this.dOperations[0] = new MBeanOperationInfo("addLoggerMBean", "addLoggerMBean(): add a loggerMBean", mBeanParameterInfoArray, "javax.management.ObjectName", 1);
    }

    public ObjectName addLoggerMBean(String string) {
        Logger logger = Category.exists(string);
        if (logger != null) {
            return this.addLoggerMBean(logger);
        }
        return null;
    }

    ObjectName addLoggerMBean(Logger logger) {
        String string = logger.getName();
        ObjectName objectName = null;
        try {
            LoggerDynamicMBean loggerDynamicMBean = new LoggerDynamicMBean(logger);
            objectName = new ObjectName("log4j", "logger", string);
            this.server.registerMBean(loggerDynamicMBean, objectName);
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType(new StringBuffer().append("addAppender.").append(logger.getName()).toString());
            log.debug(new StringBuffer().append("---Adding logger [").append(string).append("] as listener.").toString());
            this.nbs.addNotificationListener(loggerDynamicMBean, notificationFilterSupport, null);
            this.vAttributes.add(new MBeanAttributeInfo(new StringBuffer().append("logger=").append(string).toString(), "javax.management.ObjectName", new StringBuffer().append("The ").append(string).append(" logger.").toString(), true, true, false));
        }
        catch (Exception exception) {
            log.error(new StringBuffer().append("Couls not add loggerMBean for [").append(string).append("].").toString());
        }
        return objectName;
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.nbs.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[this.vAttributes.size()];
        this.vAttributes.toArray(mBeanAttributeInfoArray);
        return new MBeanInfo(this.dClassName, this.dDescription, mBeanAttributeInfoArray, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.nbs.getNotificationInfo();
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), new StringBuffer().append("Cannot invoke a null operation in ").append(this.dClassName).toString());
        }
        if (string.equals("addLoggerMBean")) {
            return this.addLoggerMBean((String)objectArray[0]);
        }
        throw new ReflectionException(new NoSuchMethodException(string), new StringBuffer().append("Cannot find the operation ").append(string).append(" in ").append(this.dClassName).toString());
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), new StringBuffer().append("Cannot invoke a getter of ").append(this.dClassName).append(" with null attribute name").toString());
        }
        log.debug(new StringBuffer().append("Called getAttribute with [").append(string).append("].").toString());
        if (string.equals("threshold")) {
            return this.hierarchy.getThreshold();
        }
        if (string.startsWith("logger")) {
            int n = string.indexOf("%3D");
            String string2 = string;
            if (n > 0) {
                string2 = new StringBuffer().append(string.substring(0, n)).append('=').append(string.substring(n + 3)).toString();
            }
            try {
                return new ObjectName(new StringBuffer().append("log4j:").append(string2).toString());
            }
            catch (Exception exception) {
                log.error(new StringBuffer().append("Could not create ObjectName").append(string2).toString());
            }
        }
        throw new AttributeNotFoundException(new StringBuffer().append("Cannot find ").append(string).append(" attribute in ").append(this.dClassName).toString());
    }

    @Override
    public void addAppenderEvent(Category category, Appender appender) {
        log.debug(new StringBuffer().append("addAppenderEvent called: logger=").append(category.getName()).append(", appender=").append(appender.getName()).toString());
        Notification notification = new Notification(new StringBuffer().append("addAppender.").append(category.getName()).toString(), this, 0L);
        notification.setUserData(appender);
        log.debug("sending notification.");
        this.nbs.sendNotification(notification);
    }

    @Override
    public void removeAppenderEvent(Category category, Appender appender) {
        log.debug(new StringBuffer().append("removeAppenderCalled: logger=").append(category.getName()).append(", appender=").append(appender.getName()).toString());
    }

    @Override
    public void postRegister(Boolean bl) {
        log.debug("postRegister is called.");
        this.hierarchy.addHierarchyEventListener(this);
        Logger logger = this.hierarchy.getRootLogger();
        this.addLoggerMBean(logger);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.nbs.removeNotificationListener(notificationListener);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), new StringBuffer().append("Cannot invoke a setter of ").append(this.dClassName).append(" with null attribute").toString());
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), new StringBuffer().append("Cannot invoke the setter of ").append(this.dClassName).append(" with null attribute name").toString());
        }
        if (string.equals("threshold")) {
            Level level = OptionConverter.toLevel((String)object, this.hierarchy.getThreshold());
            this.hierarchy.setThreshold(level);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

