/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.jmx;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jetbrains.jet.internal.org.apache.log4j.Appender;
import org.jetbrains.jet.internal.org.apache.log4j.Layout;
import org.jetbrains.jet.internal.org.apache.log4j.Level;
import org.jetbrains.jet.internal.org.apache.log4j.Logger;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.OptionConverter;
import org.jetbrains.jet.internal.org.apache.log4j.jmx.AbstractDynamicMBean;
import org.jetbrains.jet.internal.org.apache.log4j.jmx.LayoutDynamicMBean;
import org.jetbrains.jet.internal.org.apache.log4j.jmx.MethodUnion;
import org.jetbrains.jet.internal.org.apache.log4j.spi.OptionHandler;

public class AppenderDynamicMBean
extends AbstractDynamicMBean {
    private MBeanConstructorInfo[] dConstructors = new MBeanConstructorInfo[1];
    private Vector dAttributes = new Vector();
    private String dClassName = this.getClass().getName();
    private Hashtable dynamicProps = new Hashtable(5);
    private MBeanOperationInfo[] dOperations = new MBeanOperationInfo[2];
    private String dDescription = "This MBean acts as a management facade for log4j appenders.";
    private static Logger cat = Logger.getLogger(class$org$apache$log4j$jmx$AppenderDynamicMBean == null ? (class$org$apache$log4j$jmx$AppenderDynamicMBean = AppenderDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.jmx.AppenderDynamicMBean")) : class$org$apache$log4j$jmx$AppenderDynamicMBean);
    private Appender appender;
    static /* synthetic */ Class class$org$apache$log4j$jmx$AppenderDynamicMBean;
    static /* synthetic */ Class class$org$apache$log4j$Priority;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$Layout;

    public AppenderDynamicMBean(Appender appender) throws IntrospectionException {
        this.appender = appender;
        this.buildDynamicMBeanInfo();
    }

    private void buildDynamicMBeanInfo() throws IntrospectionException {
        MBeanParameterInfo[] mBeanParameterInfoArray;
        Constructor<?>[] constructorArray = this.getClass().getConstructors();
        this.dConstructors[0] = new MBeanConstructorInfo("AppenderDynamicMBean(): Constructs a AppenderDynamicMBean instance", constructorArray[0]);
        BeanInfo beanInfo = Introspector.getBeanInfo(this.appender.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz;
            mBeanParameterInfoArray = propertyDescriptorArray[n2].getName();
            Method method = propertyDescriptorArray[n2].getReadMethod();
            Method method2 = propertyDescriptorArray[n2].getWriteMethod();
            if (method != null && this.isSupportedType(clazz = method.getReturnType())) {
                String string = clazz.isAssignableFrom(class$org$apache$log4j$Priority == null ? AppenderDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.Priority") : class$org$apache$log4j$Priority) ? "java.lang.String" : clazz.getName();
                this.dAttributes.add(new MBeanAttributeInfo((String)mBeanParameterInfoArray, string, "Dynamic", true, method2 != null, false));
                this.dynamicProps.put(mBeanParameterInfoArray, new MethodUnion(method, method2));
            }
            ++n2;
        }
        mBeanParameterInfoArray = new MBeanParameterInfo[]{};
        this.dOperations[0] = new MBeanOperationInfo("activateOptions", "activateOptions(): add an appender", mBeanParameterInfoArray, "void", 1);
        mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("layout class", "java.lang.String", "layout class")};
        this.dOperations[1] = new MBeanOperationInfo("setLayout", "setLayout(): add a layout", mBeanParameterInfoArray, "void", 1);
    }

    private boolean isSupportedType(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AppenderDynamicMBean.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        return clazz.isAssignableFrom(class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = AppenderDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.Priority")) : class$org$apache$log4j$Priority);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        cat.debug("getMBeanInfo called.");
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[this.dAttributes.size()];
        this.dAttributes.toArray(mBeanAttributeInfoArray);
        return new MBeanInfo(this.dClassName, this.dDescription, mBeanAttributeInfoArray, this.dConstructors, this.dOperations, new MBeanNotificationInfo[0]);
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string.equals("activateOptions") && this.appender instanceof OptionHandler) {
            OptionHandler optionHandler = (OptionHandler)((Object)this.appender);
            optionHandler.activateOptions();
            return "Options activated.";
        }
        if (string.equals("setLayout")) {
            Layout layout = (Layout)OptionConverter.instantiateByClassName((String)objectArray[0], class$org$apache$log4j$Layout == null ? (class$org$apache$log4j$Layout = AppenderDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.Layout")) : class$org$apache$log4j$Layout, null);
            this.appender.setLayout(layout);
            this.registerLayoutMBean(layout);
        }
        return null;
    }

    void registerLayoutMBean(Layout layout) {
        if (layout == null) {
            return;
        }
        String string = new StringBuffer().append(this.appender.getName()).append(",layout=").append(layout.getClass().getName()).toString();
        cat.debug(new StringBuffer().append("Adding LayoutMBean:").append(string).toString());
        ObjectName objectName = null;
        try {
            LayoutDynamicMBean layoutDynamicMBean = new LayoutDynamicMBean(layout);
            objectName = new ObjectName(new StringBuffer().append("log4j:appender=").append(string).toString());
            this.server.registerMBean(layoutDynamicMBean, objectName);
            this.dAttributes.add(new MBeanAttributeInfo(new StringBuffer().append("appender=").append(string).toString(), "javax.management.ObjectName", new StringBuffer().append("The ").append(string).append(" layout.").toString(), true, true, false));
        }
        catch (Exception exception) {
            cat.error(new StringBuffer().append("Could not add DynamicLayoutMBean for [").append(string).append("].").toString(), exception);
        }
    }

    @Override
    protected Logger getLogger() {
        return cat;
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MethodUnion methodUnion;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), new StringBuffer().append("Cannot invoke a getter of ").append(this.dClassName).append(" with null attribute name").toString());
        }
        cat.debug(new StringBuffer().append("getAttribute called with [").append(string).append("].").toString());
        if (string.startsWith(new StringBuffer().append("appender=").append(this.appender.getName()).append(",layout").toString())) {
            try {
                return new ObjectName(new StringBuffer().append("log4j:").append(string).toString());
            }
            catch (Exception exception) {
                cat.error("attributeName", exception);
            }
        }
        if ((methodUnion = (MethodUnion)this.dynamicProps.get(string)) != null && methodUnion.readMethod != null) {
            try {
                return methodUnion.readMethod.invoke((Object)this.appender, null);
            }
            catch (Exception exception) {
                return null;
            }
        }
        throw new AttributeNotFoundException(new StringBuffer().append("Cannot find ").append(string).append(" attribute in ").append(this.dClassName).toString());
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), new StringBuffer().append("Cannot invoke a setter of ").append(this.dClassName).append(" with null attribute").toString());
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), new StringBuffer().append("Cannot invoke the setter of ").append(this.dClassName).append(" with null attribute name").toString());
        }
        MethodUnion methodUnion = (MethodUnion)this.dynamicProps.get(string);
        if (methodUnion != null && methodUnion.writeMethod != null) {
            Object[] objectArray = new Object[1];
            Class<?>[] classArray = methodUnion.writeMethod.getParameterTypes();
            if (classArray[0] == (class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = AppenderDynamicMBean.class$("org.jetbrains.jet.internal.org.apache.log4j.Priority")) : class$org$apache$log4j$Priority)) {
                object = OptionConverter.toLevel((String)object, (Level)this.getAttribute(string));
            }
            objectArray[0] = object;
            try {
                methodUnion.writeMethod.invoke((Object)this.appender, objectArray);
            }
            catch (Exception exception) {
                cat.error("FIXME", exception);
            }
        } else if (!string.endsWith(".layout")) {
            throw new AttributeNotFoundException(new StringBuffer().append("Attribute ").append(string).append(" not found in ").append(this.getClass().getName()).toString());
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        cat.debug(new StringBuffer().append("preRegister called. Server=").append(mBeanServer).append(", name=").append(objectName).toString());
        this.server = mBeanServer;
        this.registerLayoutMBean(this.appender.getLayout());
        return objectName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

