/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.jmx;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.jetbrains.jet.internal.org.apache.log4j.Logger;

public abstract class AbstractDynamicMBean
implements DynamicMBean,
MBeanRegistration {
    String dClassName;
    MBeanServer server;

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), new StringBuffer().append("Cannot invoke a getter of ").append(this.dClassName).toString());
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                Object object = this.getAttribute(stringArray[n]);
                attributeList.add(new Attribute(stringArray[n], object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes cannot be null"), new StringBuffer().append("Cannot invoke a setter of ").append(this.dClassName).toString());
        }
        AttributeList attributeList2 = new AttributeList();
        if (attributeList.isEmpty()) {
            return attributeList2;
        }
        for (Attribute attribute : attributeList) {
            try {
                this.setAttribute(attribute);
                String string = attribute.getName();
                Object object = this.getAttribute(string);
                attributeList2.add(new Attribute(string, object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return attributeList2;
    }

    protected abstract Logger getLogger();

    @Override
    public void postDeregister() {
        this.getLogger().debug("postDeregister is called.");
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() {
        this.getLogger().debug("preDeregister called.");
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        this.getLogger().debug(new StringBuffer().append("preRegister called. Server=").append(mBeanServer).append(", name=").append(objectName).toString());
        this.server = mBeanServer;
        return objectName;
    }

    @Override
    public abstract void setAttribute(Attribute var1) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException;

    @Override
    public abstract Object invoke(String var1, Object[] var2, String[] var3) throws MBeanException, ReflectionException;

    @Override
    public abstract MBeanInfo getMBeanInfo();

    @Override
    public abstract Object getAttribute(String var1) throws AttributeNotFoundException, MBeanException, ReflectionException;
}

