/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.helpers;

import java.io.IOException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.LogLog;

public class SyslogWriter
extends Writer {
    final int SYSLOG_PORT = 514;
    static String syslogHost;
    private InetAddress address;
    private DatagramSocket ds;

    public SyslogWriter(String syslogHost) {
        SyslogWriter.syslogHost = syslogHost;
        try {
            this.address = InetAddress.getByName(syslogHost);
        }
        catch (UnknownHostException e) {
            LogLog.error(new StringBuffer().append("Could not find ").append(syslogHost).append(". All logging will FAIL.").toString(), e);
        }
        try {
            this.ds = new DatagramSocket();
        }
        catch (SocketException e) {
            e.printStackTrace();
            LogLog.error(new StringBuffer().append("Could not instantiate DatagramSocket to ").append(syslogHost).append(". All logging will FAIL.").toString(), e);
        }
    }

    @Override
    public void write(char[] buf, int off, int len) throws IOException {
        this.write(new String(buf, off, len));
    }

    @Override
    public void write(String string) throws IOException {
        byte[] bytes = string.getBytes();
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.address, 514);
        if (this.ds != null) {
            this.ds.send(packet);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

