/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.helpers;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.jetbrains.jet.internal.org.apache.log4j.spi.ErrorHandler;

public class QuietWriter
extends FilterWriter {
    protected ErrorHandler errorHandler;

    public QuietWriter(Writer writer, ErrorHandler errorHandler) {
        super(writer);
        this.setErrorHandler(errorHandler);
    }

    @Override
    public void write(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException e) {
            this.errorHandler.error(new StringBuffer().append("Failed to write [").append(string).append("].").toString(), e, 1);
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.errorHandler.error("Failed to flush writer,", e, 2);
        }
    }

    public void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            throw new IllegalArgumentException("Attempted to set null ErrorHandler.");
        }
        this.errorHandler = eh;
    }
}

