/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.helpers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.jet.internal.org.apache.log4j.Layout;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.AbsoluteTimeDateFormat;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.DateTimeDateFormat;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.FormattingInfo;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.ISO8601DateFormat;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.LogLog;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.OptionConverter;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.PatternConverter;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LocationInfo;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggingEvent;

public class PatternParser {
    int state;
    protected StringBuffer currentLiteral = new StringBuffer(32);
    protected int patternLength;
    protected int i;
    PatternConverter head;
    PatternConverter tail;
    protected FormattingInfo formattingInfo = new FormattingInfo();
    protected String pattern;
    static /* synthetic */ Class class$java$text$DateFormat;

    public PatternParser(String pattern) {
        this.pattern = pattern;
        this.patternLength = pattern.length();
        this.state = 0;
    }

    private void addToList(PatternConverter pc) {
        if (this.head == null) {
            this.head = this.tail = pc;
        } else {
            this.tail.next = pc;
            this.tail = pc;
        }
    }

    protected String extractOption() {
        int end;
        if (this.i < this.patternLength && this.pattern.charAt(this.i) == '{' && (end = this.pattern.indexOf(125, this.i)) > this.i) {
            String r = this.pattern.substring(this.i + 1, end);
            this.i = end + 1;
            return r;
        }
        return null;
    }

    protected int extractPrecisionOption() {
        String opt = this.extractOption();
        int r = 0;
        if (opt != null) {
            try {
                r = Integer.parseInt(opt);
                if (r <= 0) {
                    LogLog.error(new StringBuffer().append("Precision option (").append(opt).append(") isn't a positive integer.").toString());
                    r = 0;
                }
            }
            catch (NumberFormatException e) {
                LogLog.error(new StringBuffer().append("Category option \"").append(opt).append("\" not a decimal integer.").toString(), e);
            }
        }
        return r;
    }

    public PatternConverter parse() {
        this.i = 0;
        while (this.i < this.patternLength) {
            char c = this.pattern.charAt(this.i++);
            block0 : switch (this.state) {
                case 0: {
                    if (this.i == this.patternLength) {
                        this.currentLiteral.append(c);
                        break;
                    }
                    if (c == '%') {
                        switch (this.pattern.charAt(this.i)) {
                            case '%': {
                                this.currentLiteral.append(c);
                                ++this.i;
                                break block0;
                            }
                            case 'n': {
                                this.currentLiteral.append(Layout.LINE_SEP);
                                ++this.i;
                                break block0;
                            }
                        }
                        if (this.currentLiteral.length() != 0) {
                            this.addToList(new LiteralPatternConverter(this.currentLiteral.toString()));
                        }
                        this.currentLiteral.setLength(0);
                        this.currentLiteral.append(c);
                        this.state = 1;
                        this.formattingInfo.reset();
                        break;
                    }
                    this.currentLiteral.append(c);
                    break;
                }
                case 1: {
                    this.currentLiteral.append(c);
                    switch (c) {
                        case '-': {
                            this.formattingInfo.leftAlign = true;
                            break block0;
                        }
                        case '.': {
                            this.state = 3;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.min = c - 48;
                        this.state = 4;
                        break;
                    }
                    this.finalizeConverter(c);
                    break;
                }
                case 4: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.min = this.formattingInfo.min * 10 + (c - 48);
                        break;
                    }
                    if (c == '.') {
                        this.state = 3;
                        break;
                    }
                    this.finalizeConverter(c);
                    break;
                }
                case 3: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.max = c - 48;
                        this.state = 5;
                        break;
                    }
                    LogLog.error(new StringBuffer().append("Error occured in position ").append(this.i).append(".\n Was expecting digit, instead got char \"").append(c).append("\".").toString());
                    this.state = 0;
                    break;
                }
                case 5: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.max = this.formattingInfo.max * 10 + (c - 48);
                        break;
                    }
                    this.finalizeConverter(c);
                    this.state = 0;
                }
            }
        }
        if (this.currentLiteral.length() != 0) {
            this.addToList(new LiteralPatternConverter(this.currentLiteral.toString()));
        }
        return this.head;
    }

    protected void finalizeConverter(char c) {
        PatternConverter pc = null;
        switch (c) {
            case 'c': {
                pc = new CategoryPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                this.currentLiteral.setLength(0);
                break;
            }
            case 'C': {
                pc = new ClassNamePatternConverter(this.formattingInfo, this.extractPrecisionOption());
                this.currentLiteral.setLength(0);
                break;
            }
            case 'd': {
                DateFormat df;
                String dateFormatStr = "ISO8601";
                String dOpt = this.extractOption();
                if (dOpt != null) {
                    dateFormatStr = dOpt;
                }
                if (dateFormatStr.equalsIgnoreCase("ISO8601")) {
                    df = new ISO8601DateFormat();
                } else if (dateFormatStr.equalsIgnoreCase("ABSOLUTE")) {
                    df = new AbsoluteTimeDateFormat();
                } else if (dateFormatStr.equalsIgnoreCase("DATE")) {
                    df = new DateTimeDateFormat();
                } else {
                    try {
                        df = new SimpleDateFormat(dateFormatStr);
                    }
                    catch (IllegalArgumentException e) {
                        LogLog.error(new StringBuffer().append("Could not instantiate SimpleDateFormat with ").append(dateFormatStr).toString(), e);
                        df = (DateFormat)OptionConverter.instantiateByClassName("org.jetbrains.jet.internal.org.apache.log4j.helpers.ISO8601DateFormat", class$java$text$DateFormat == null ? (class$java$text$DateFormat = PatternParser.class$("java.text.DateFormat")) : class$java$text$DateFormat, null);
                    }
                }
                pc = new DatePatternConverter(this.formattingInfo, df);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'F': {
                pc = new LocationPatternConverter(this.formattingInfo, 1004);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'l': {
                pc = new LocationPatternConverter(this.formattingInfo, 1000);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'L': {
                pc = new LocationPatternConverter(this.formattingInfo, 1003);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'm': {
                pc = new BasicPatternConverter(this.formattingInfo, 2004);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'M': {
                pc = new LocationPatternConverter(this.formattingInfo, 1001);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'p': {
                pc = new BasicPatternConverter(this.formattingInfo, 2002);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'r': {
                pc = new BasicPatternConverter(this.formattingInfo, 2000);
                this.currentLiteral.setLength(0);
                break;
            }
            case 't': {
                pc = new BasicPatternConverter(this.formattingInfo, 2001);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'x': {
                pc = new BasicPatternConverter(this.formattingInfo, 2003);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'X': {
                String xOpt = this.extractOption();
                pc = new MDCPatternConverter(this.formattingInfo, xOpt);
                this.currentLiteral.setLength(0);
                break;
            }
            default: {
                LogLog.error(new StringBuffer().append("Unexpected char [").append(c).append("] at position ").append(this.i).append(" in conversion patterrn.").toString());
                pc = new LiteralPatternConverter(this.currentLiteral.toString());
                this.currentLiteral.setLength(0);
            }
        }
        this.addConverter(pc);
    }

    protected void addConverter(PatternConverter pc) {
        this.currentLiteral.setLength(0);
        this.addToList(pc);
        this.state = 0;
        this.formattingInfo.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CategoryPatternConverter
    extends NamedPatternConverter {
        CategoryPatternConverter(FormattingInfo formattingInfo, int precision) {
            super(formattingInfo, precision);
        }

        @Override
        String getFullyQualifiedName(LoggingEvent event) {
            return event.categoryName;
        }
    }

    private class ClassNamePatternConverter
    extends NamedPatternConverter {
        ClassNamePatternConverter(FormattingInfo formattingInfo, int precision) {
            super(formattingInfo, precision);
        }

        @Override
        String getFullyQualifiedName(LoggingEvent event) {
            return event.getLocationInformation().getClassName();
        }
    }

    private static abstract class NamedPatternConverter
    extends PatternConverter {
        int precision;

        NamedPatternConverter(FormattingInfo formattingInfo, int precision) {
            super(formattingInfo);
            this.precision = precision;
        }

        abstract String getFullyQualifiedName(LoggingEvent var1);

        @Override
        public String convert(LoggingEvent event) {
            String n = this.getFullyQualifiedName(event);
            if (this.precision <= 0) {
                return n;
            }
            int len = n.length();
            int end = len - 1;
            int i = this.precision;
            while (i > 0) {
                if ((end = n.lastIndexOf(46, end - 1)) == -1) {
                    return n;
                }
                --i;
            }
            return n.substring(end + 1, len);
        }
    }

    private class LocationPatternConverter
    extends PatternConverter {
        int type;

        LocationPatternConverter(FormattingInfo formattingInfo, int type) {
            super(formattingInfo);
            this.type = type;
        }

        @Override
        public String convert(LoggingEvent event) {
            LocationInfo locationInfo = event.getLocationInformation();
            switch (this.type) {
                case 1000: {
                    return locationInfo.fullInfo;
                }
                case 1001: {
                    return locationInfo.getMethodName();
                }
                case 1003: {
                    return locationInfo.getLineNumber();
                }
                case 1004: {
                    return locationInfo.getFileName();
                }
            }
            return null;
        }
    }

    private static class MDCPatternConverter
    extends PatternConverter {
        private String key;

        MDCPatternConverter(FormattingInfo formattingInfo, String key) {
            super(formattingInfo);
            this.key = key;
        }

        @Override
        public String convert(LoggingEvent event) {
            Object val = event.getMDC(this.key);
            if (val == null) {
                return null;
            }
            return val.toString();
        }
    }

    private static class DatePatternConverter
    extends PatternConverter {
        private DateFormat df;
        private Date date = new Date();

        DatePatternConverter(FormattingInfo formattingInfo, DateFormat df) {
            super(formattingInfo);
            this.df = df;
        }

        @Override
        public String convert(LoggingEvent event) {
            this.date.setTime(event.timeStamp);
            String converted = null;
            try {
                converted = this.df.format(this.date);
            }
            catch (Exception ex) {
                LogLog.error("Error occured while converting date.", ex);
            }
            return converted;
        }
    }

    private static class LiteralPatternConverter
    extends PatternConverter {
        private String literal;

        LiteralPatternConverter(String value) {
            this.literal = value;
        }

        @Override
        public final void format(StringBuffer sbuf, LoggingEvent event) {
            sbuf.append(this.literal);
        }

        @Override
        public String convert(LoggingEvent event) {
            return this.literal;
        }
    }

    private static class BasicPatternConverter
    extends PatternConverter {
        int type;

        BasicPatternConverter(FormattingInfo formattingInfo, int type) {
            super(formattingInfo);
            this.type = type;
        }

        @Override
        public String convert(LoggingEvent event) {
            switch (this.type) {
                case 2000: {
                    return Long.toString(event.timeStamp - LoggingEvent.getStartTime());
                }
                case 2001: {
                    return event.getThreadName();
                }
                case 2002: {
                    return event.level.toString();
                }
                case 2003: {
                    return event.getNDC();
                }
                case 2004: {
                    return event.getRenderedMessage();
                }
            }
            return null;
        }
    }
}

