/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.helpers;

import org.jetbrains.jet.internal.org.apache.log4j.helpers.OptionConverter;

public class LogLog {
    public static final String DEBUG_KEY = "log4j.debug";
    public static final String CONFIG_DEBUG_KEY = "log4j.configDebug";
    protected static boolean debugEnabled = false;
    private static boolean quietMode = false;

    public static void setInternalDebugging(boolean enabled) {
        debugEnabled = enabled;
    }

    public static void debug(String msg) {
        if (debugEnabled && !quietMode) {
            System.out.println(new StringBuffer().append("log4j: ").append(msg).toString());
        }
    }

    public static void debug(String msg, Throwable t) {
        if (debugEnabled && !quietMode) {
            System.out.println(new StringBuffer().append("log4j: ").append(msg).toString());
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    public static void error(String msg) {
        if (quietMode) {
            return;
        }
        System.err.println(new StringBuffer().append("log4j:ERROR ").append(msg).toString());
    }

    public static void error(String msg, Throwable t) {
        if (quietMode) {
            return;
        }
        System.err.println(new StringBuffer().append("log4j:ERROR ").append(msg).toString());
        if (t != null) {
            t.printStackTrace();
        }
    }

    public static void setQuietMode(boolean quietMode) {
        LogLog.quietMode = quietMode;
    }

    public static void warn(String msg) {
        if (quietMode) {
            return;
        }
        System.err.println(new StringBuffer().append("log4j:WARN ").append(msg).toString());
    }

    public static void warn(String msg, Throwable t) {
        if (quietMode) {
            return;
        }
        System.err.println(new StringBuffer().append("log4j:WARN ").append(msg).toString());
        if (t != null) {
            t.printStackTrace();
        }
    }

    static {
        String key = OptionConverter.getSystemProperty(DEBUG_KEY, null);
        if (key == null) {
            key = OptionConverter.getSystemProperty(CONFIG_DEBUG_KEY, null);
        }
        if (key != null) {
            debugEnabled = OptionConverter.toBoolean(key, true);
        }
    }
}

