/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.helpers;

import java.io.File;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.LogLog;

public abstract class FileWatchdog
extends Thread {
    public static final long DEFAULT_DELAY = 60000L;
    protected String filename;
    protected long delay = 60000L;
    File file;
    long lastModif = 0L;
    boolean warnedAlready = false;
    boolean interrupted = false;

    protected FileWatchdog(String filename) {
        this.filename = filename;
        this.file = new File(filename);
        this.setDaemon(true);
        this.checkAndConfigure();
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected abstract void doOnChange();

    protected void checkAndConfigure() {
        boolean fileExists;
        try {
            fileExists = this.file.exists();
        }
        catch (SecurityException e) {
            LogLog.warn(new StringBuffer().append("Was not allowed to read check file existance, file:[").append(this.filename).append("].").toString());
            this.interrupted = true;
            return;
        }
        if (fileExists) {
            long l = this.file.lastModified();
            if (l > this.lastModif) {
                this.lastModif = l;
                this.doOnChange();
                this.warnedAlready = false;
            }
        } else if (!this.warnedAlready) {
            LogLog.debug(new StringBuffer().append("[").append(this.filename).append("] does not exist.").toString());
            this.warnedAlready = true;
        }
    }

    @Override
    public void run() {
        while (!this.interrupted) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkAndConfigure();
        }
    }
}

