/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.config;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jetbrains.jet.internal.org.apache.log4j.Appender;
import org.jetbrains.jet.internal.org.apache.log4j.Category;
import org.jetbrains.jet.internal.org.apache.log4j.Level;
import org.jetbrains.jet.internal.org.apache.log4j.config.PropertyGetter;

public class PropertyPrinter
implements PropertyGetter.PropertyCallback {
    protected int numAppenders = 0;
    protected Hashtable appenderNames = new Hashtable();
    protected Hashtable layoutNames = new Hashtable();
    protected PrintWriter out;
    protected boolean doCapitalize;

    public PropertyPrinter(PrintWriter out) {
        this(out, false);
    }

    public PropertyPrinter(PrintWriter out, boolean doCapitalize) {
        this.out = out;
        this.doCapitalize = doCapitalize;
        this.print(out);
        out.flush();
    }

    protected String genAppName() {
        return new StringBuffer().append("A").append(this.numAppenders++).toString();
    }

    protected boolean isGenAppName(String name) {
        if (name.length() < 2 || name.charAt(0) != 'A') {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) < '0' || name.charAt(i) > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void print(PrintWriter out) {
        this.printOptions(out, Category.getRoot());
        Enumeration cats = Category.getCurrentCategories();
        while (cats.hasMoreElements()) {
            this.printOptions(out, (Category)cats.nextElement());
        }
    }

    protected void printOptions(PrintWriter out, Category cat) {
        String catKey;
        Enumeration appenders = cat.getAllAppenders();
        Level prio = cat.getLevel();
        String appenderString = prio == null ? "" : prio.toString();
        while (appenders.hasMoreElements()) {
            Appender app = (Appender)appenders.nextElement();
            String name = (String)this.appenderNames.get(app);
            if (name == null) {
                name = app.getName();
                if (name == null || this.isGenAppName(name)) {
                    name = this.genAppName();
                }
                this.appenderNames.put(app, name);
                this.printOptions(out, app, new StringBuffer().append("log4j.appender.").append(name).toString());
                if (app.getLayout() != null) {
                    this.printOptions(out, app.getLayout(), new StringBuffer().append("log4j.appender.").append(name).append(".layout").toString());
                }
            }
            appenderString = new StringBuffer().append(appenderString).append(", ").append(name).toString();
        }
        String string = catKey = cat == Category.getRoot() ? "log4j.rootCategory" : new StringBuffer().append("log4j.category.").append(cat.getName()).toString();
        if (appenderString != "") {
            out.println(new StringBuffer().append(catKey).append("=").append(appenderString).toString());
        }
    }

    protected void printOptions(PrintWriter out, Object obj, String fullname) {
        out.println(new StringBuffer().append(fullname).append("=").append(obj.getClass().getName()).toString());
        PropertyGetter.getProperties(obj, this, new StringBuffer().append(fullname).append(".").toString());
    }

    @Override
    public void foundProperty(Object obj, String prefix, String name, Object value) {
        if (obj instanceof Appender && "name".equals(name)) {
            return;
        }
        if (this.doCapitalize) {
            name = PropertyPrinter.capitalize(name);
        }
        this.out.println(new StringBuffer().append(prefix).append(name).append("=").append(value.toString()).toString());
    }

    public static String capitalize(String name) {
        if (Character.isLowerCase(name.charAt(0)) && (name.length() == 1 || Character.isLowerCase(name.charAt(1)))) {
            StringBuffer newname = new StringBuffer(name);
            newname.setCharAt(0, Character.toUpperCase(name.charAt(0)));
            return newname.toString();
        }
        return name;
    }

    public static void main(String[] args) {
        new PropertyPrinter(new PrintWriter(System.out));
    }
}

