/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j.chainsaw;

import java.util.StringTokenizer;
import org.jetbrains.jet.internal.org.apache.log4j.Priority;
import org.jetbrains.jet.internal.org.apache.log4j.chainsaw.EventDetails;
import org.jetbrains.jet.internal.org.apache.log4j.chainsaw.MyTableModel;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XMLFileHandler
extends DefaultHandler {
    private final MyTableModel mModel;
    private int mNumEvents;
    private long mTimeStamp;
    private Priority mPriority;
    private String mCategoryName;
    private String mNDC;
    private String mThreadName;
    private String mMessage;
    private String[] mThrowableStrRep;
    private String mLocationDetails;
    private final StringBuffer mBuf = new StringBuffer();

    XMLFileHandler(MyTableModel aModel) {
        this.mModel = aModel;
    }

    @Override
    public void startDocument() throws SAXException {
        this.mNumEvents = 0;
    }

    @Override
    public void characters(char[] aChars, int aStart, int aLength) {
        this.mBuf.append(String.valueOf(aChars, aStart, aLength));
    }

    @Override
    public void endElement(String aNamespaceURI, String aLocalName, String aQName) {
        if ("log4j:event".equals(aQName)) {
            this.addEvent();
            this.resetData();
        } else if ("log4j:NDC".equals(aQName)) {
            this.mNDC = this.mBuf.toString();
        } else if ("log4j:message".equals(aQName)) {
            this.mMessage = this.mBuf.toString();
        } else if ("log4j:throwable".equals(aQName)) {
            StringTokenizer st = new StringTokenizer(this.mBuf.toString(), "\n\t");
            this.mThrowableStrRep = new String[st.countTokens()];
            if (this.mThrowableStrRep.length > 0) {
                this.mThrowableStrRep[0] = st.nextToken();
                int i = 1;
                while (i < this.mThrowableStrRep.length) {
                    this.mThrowableStrRep[i] = new StringBuffer().append("\t").append(st.nextToken()).toString();
                    ++i;
                }
            }
        }
    }

    @Override
    public void startElement(String aNamespaceURI, String aLocalName, String aQName, Attributes aAtts) {
        this.mBuf.setLength(0);
        if ("log4j:event".equals(aQName)) {
            this.mThreadName = aAtts.getValue("thread");
            this.mTimeStamp = Long.parseLong(aAtts.getValue("timestamp"));
            this.mCategoryName = aAtts.getValue("logger");
            this.mPriority = Priority.toPriority(aAtts.getValue("level"));
        } else if ("log4j:locationInfo".equals(aQName)) {
            this.mLocationDetails = new StringBuffer().append(aAtts.getValue("class")).append(".").append(aAtts.getValue("method")).append("(").append(aAtts.getValue("file")).append(":").append(aAtts.getValue("line")).append(")").toString();
        }
    }

    int getNumEvents() {
        return this.mNumEvents;
    }

    private void addEvent() {
        this.mModel.addEvent(new EventDetails(this.mTimeStamp, this.mPriority, this.mCategoryName, this.mNDC, this.mThreadName, this.mMessage, this.mThrowableStrRep, this.mLocationDetails));
        ++this.mNumEvents;
    }

    private void resetData() {
        this.mTimeStamp = 0L;
        this.mPriority = null;
        this.mCategoryName = null;
        this.mNDC = null;
        this.mThreadName = null;
        this.mMessage = null;
        this.mThrowableStrRep = null;
        this.mLocationDetails = null;
    }
}

