/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.jetbrains.jet.internal.org.apache.log4j.FileAppender;
import org.jetbrains.jet.internal.org.apache.log4j.Layout;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.CountingQuietWriter;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.LogLog;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.OptionConverter;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggingEvent;

public class RollingFileAppender
extends FileAppender {
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupIndex = 1;

    public RollingFileAppender() {
    }

    public RollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public RollingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void rollOver() {
        LogLog.debug(new StringBuffer().append("rolling over count=").append(((CountingQuietWriter)this.qw).getCount()).toString());
        LogLog.debug(new StringBuffer().append("maxBackupIndex=").append(this.maxBackupIndex).toString());
        if (this.maxBackupIndex > 0) {
            File target;
            File file = new File(new StringBuffer().append(this.fileName).append('.').append(this.maxBackupIndex).toString());
            if (file.exists()) {
                file.delete();
            }
            int i = this.maxBackupIndex - 1;
            while (i >= 1) {
                file = new File(new StringBuffer().append(this.fileName).append(".").append(i).toString());
                if (file.exists()) {
                    target = new File(new StringBuffer().append(this.fileName).append('.').append(i + 1).toString());
                    LogLog.debug(new StringBuffer().append("Renaming file ").append(file).append(" to ").append(target).toString());
                    file.renameTo(target);
                }
                --i;
            }
            target = new File(new StringBuffer().append(this.fileName).append(".").append(1).toString());
            this.closeFile();
            file = new File(this.fileName);
            LogLog.debug(new StringBuffer().append("Renaming file ").append(file).append(" to ").append(target).toString());
            file.renameTo(target);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error(new StringBuffer().append("setFile(").append(this.fileName).append(", false) call failed.").toString(), e);
        }
    }

    @Override
    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File f = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize(value, this.maxFileSize + 1L);
    }

    @Override
    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        if (this.fileName != null && ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            this.rollOver();
        }
    }
}

