/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jetbrains.jet.internal.org.apache.log4j.Appender;
import org.jetbrains.jet.internal.org.apache.log4j.DefaultCategoryFactory;
import org.jetbrains.jet.internal.org.apache.log4j.Layout;
import org.jetbrains.jet.internal.org.apache.log4j.Level;
import org.jetbrains.jet.internal.org.apache.log4j.LogManager;
import org.jetbrains.jet.internal.org.apache.log4j.Logger;
import org.jetbrains.jet.internal.org.apache.log4j.PropertyWatchdog;
import org.jetbrains.jet.internal.org.apache.log4j.config.PropertySetter;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.LogLog;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.OptionConverter;
import org.jetbrains.jet.internal.org.apache.log4j.or.RendererMap;
import org.jetbrains.jet.internal.org.apache.log4j.spi.Configurator;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggerFactory;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggerRepository;
import org.jetbrains.jet.internal.org.apache.log4j.spi.OptionHandler;
import org.jetbrains.jet.internal.org.apache.log4j.spi.RendererSupport;

public class PropertyConfigurator
implements Configurator {
    protected Hashtable registry = new Hashtable(11);
    protected LoggerFactory loggerFactory = new DefaultCategoryFactory();
    public static final String LOGGER_FACTORY_KEY = "log4j.loggerFactory";
    static /* synthetic */ Class class$org$apache$log4j$spi$LoggerFactory;
    static /* synthetic */ Class class$org$apache$log4j$Appender;
    static /* synthetic */ Class class$org$apache$log4j$Layout;

    public void doConfigure(String configFileName, LoggerRepository hierarchy) {
        Properties props = new Properties();
        try {
            FileInputStream istream = new FileInputStream(configFileName);
            props.load(istream);
            istream.close();
        }
        catch (IOException e) {
            LogLog.error(new StringBuffer().append("Could not read configuration file [").append(configFileName).append("].").toString(), e);
            LogLog.error(new StringBuffer().append("Ignoring configuration file [").append(configFileName).append("].").toString());
            return;
        }
        this.doConfigure(props, hierarchy);
    }

    public static void configure(String configFilename) {
        new PropertyConfigurator().doConfigure(configFilename, LogManager.getLoggerRepository());
    }

    public static void configure(URL configURL) {
        new PropertyConfigurator().doConfigure(configURL, LogManager.getLoggerRepository());
    }

    public static void configure(Properties properties) {
        new PropertyConfigurator().doConfigure(properties, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String configFilename) {
        PropertyConfigurator.configureAndWatch(configFilename, 60000L);
    }

    public static void configureAndWatch(String configFilename, long delay) {
        PropertyWatchdog pdog = new PropertyWatchdog(configFilename);
        pdog.setDelay(delay);
        pdog.start();
    }

    public void doConfigure(Properties properties, LoggerRepository hierarchy) {
        String thresholdStr;
        String value = properties.getProperty("log4j.debug");
        if (value == null && (value = properties.getProperty("log4j.configDebug")) != null) {
            LogLog.warn("[log4j.configDebug] is deprecated. Use [log4j.debug] instead.");
        }
        if (value != null) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(value, true));
        }
        if ((thresholdStr = OptionConverter.findAndSubst("log4j.threshold", properties)) != null) {
            hierarchy.setThreshold(OptionConverter.toLevel(thresholdStr, Level.ALL));
            LogLog.debug(new StringBuffer().append("Hierarchy threshold set to [").append(hierarchy.getThreshold()).append("].").toString());
        }
        this.configureRootCategory(properties, hierarchy);
        this.configureLoggerFactory(properties);
        this.parseCatsAndRenderers(properties, hierarchy);
        LogLog.debug("Finished configuring.");
        this.registry.clear();
    }

    @Override
    public void doConfigure(URL configURL, LoggerRepository hierarchy) {
        Properties props = new Properties();
        LogLog.debug(new StringBuffer().append("Reading configuration from URL ").append(configURL).toString());
        try {
            props.load(configURL.openStream());
        }
        catch (IOException e) {
            LogLog.error(new StringBuffer().append("Could not read configuration file from URL [").append(configURL).append("].").toString(), e);
            LogLog.error(new StringBuffer().append("Ignoring configuration file [").append(configURL).append("].").toString());
            return;
        }
        this.doConfigure(props, hierarchy);
    }

    protected void configureLoggerFactory(Properties props) {
        String factoryClassName = OptionConverter.findAndSubst(LOGGER_FACTORY_KEY, props);
        if (factoryClassName != null) {
            LogLog.debug(new StringBuffer().append("Setting category factory to [").append(factoryClassName).append("].").toString());
            this.loggerFactory = (LoggerFactory)OptionConverter.instantiateByClassName(factoryClassName, class$org$apache$log4j$spi$LoggerFactory == null ? (class$org$apache$log4j$spi$LoggerFactory = PropertyConfigurator.class$("org.jetbrains.jet.internal.org.apache.log4j.spi.LoggerFactory")) : class$org$apache$log4j$spi$LoggerFactory, this.loggerFactory);
            PropertySetter.setProperties(this.loggerFactory, props, "log4j.factory.");
        }
    }

    void configureRootCategory(Properties props, LoggerRepository hierarchy) {
        String effectiveFrefix = "log4j.rootLogger";
        String value = OptionConverter.findAndSubst("log4j.rootLogger", props);
        if (value == null) {
            value = OptionConverter.findAndSubst("log4j.rootCategory", props);
            effectiveFrefix = "log4j.rootCategory";
        }
        if (value == null) {
            LogLog.debug("Could not find root logger information. Is this OK?");
        } else {
            Logger root;
            Logger logger = root = hierarchy.getRootLogger();
            synchronized (logger) {
                this.parseCategory(props, root, effectiveFrefix, "root", value);
            }
        }
    }

    protected void parseCatsAndRenderers(Properties props, LoggerRepository hierarchy) {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (key.startsWith("log4j.category.") || key.startsWith("log4j.logger.")) {
                Logger logger;
                String loggerName = null;
                if (key.startsWith("log4j.category.")) {
                    loggerName = key.substring("log4j.category.".length());
                } else if (key.startsWith("log4j.logger.")) {
                    loggerName = key.substring("log4j.logger.".length());
                }
                String value = OptionConverter.findAndSubst(key, props);
                Logger logger2 = logger = hierarchy.getLogger(loggerName, this.loggerFactory);
                synchronized (logger2) {
                    this.parseCategory(props, logger, key, loggerName, value);
                    this.parseAdditivityForLogger(props, logger, loggerName);
                    continue;
                }
            }
            if (!key.startsWith("log4j.renderer.")) continue;
            String renderedClass = key.substring("log4j.renderer.".length());
            String renderingClass = OptionConverter.findAndSubst(key, props);
            if (!(hierarchy instanceof RendererSupport)) continue;
            RendererMap.addRenderer((RendererSupport)((Object)hierarchy), renderedClass, renderingClass);
        }
    }

    void parseAdditivityForLogger(Properties props, Logger cat, String loggerName) {
        String value = OptionConverter.findAndSubst(new StringBuffer().append("log4j.additivity.").append(loggerName).toString(), props);
        LogLog.debug(new StringBuffer().append("Handling log4j.additivity.").append(loggerName).append("=[").append(value).append("]").toString());
        if (value != null && !value.equals("")) {
            boolean additivity = OptionConverter.toBoolean(value, true);
            LogLog.debug(new StringBuffer().append("Setting additivity for \"").append(loggerName).append("\" to ").append(additivity).toString());
            cat.setAdditivity(additivity);
        }
    }

    void parseCategory(Properties props, Logger logger, String optionKey, String loggerName, String value) {
        LogLog.debug(new StringBuffer().append("Parsing for [").append(loggerName).append("] with value=[").append(value).append("].").toString());
        StringTokenizer st = new StringTokenizer(value, ",");
        if (!value.startsWith(",") && !value.equals("")) {
            if (!st.hasMoreTokens()) {
                return;
            }
            String levelStr = st.nextToken();
            LogLog.debug(new StringBuffer().append("Level token is [").append(levelStr).append("].").toString());
            if ("inherited".equalsIgnoreCase(levelStr) || "null".equalsIgnoreCase(levelStr)) {
                if (loggerName.equals("root")) {
                    LogLog.warn("The root logger cannot be set to null.");
                } else {
                    logger.setLevel(null);
                }
            } else {
                logger.setLevel(OptionConverter.toLevel(levelStr, Level.DEBUG));
            }
            LogLog.debug(new StringBuffer().append("Category ").append(loggerName).append(" set to ").append(logger.getLevel()).toString());
        }
        logger.removeAllAppenders();
        while (st.hasMoreTokens()) {
            String appenderName = st.nextToken().trim();
            if (appenderName == null || appenderName.equals(",")) continue;
            LogLog.debug(new StringBuffer().append("Parsing appender named \"").append(appenderName).append("\".").toString());
            Appender appender = this.parseAppender(props, appenderName);
            if (appender == null) continue;
            logger.addAppender(appender);
        }
    }

    Appender parseAppender(Properties props, String appenderName) {
        Appender appender = this.registryGet(appenderName);
        if (appender != null) {
            LogLog.debug(new StringBuffer().append("Appender \"").append(appenderName).append("\" was already parsed.").toString());
            return appender;
        }
        String prefix = new StringBuffer().append("log4j.appender.").append(appenderName).toString();
        String layoutPrefix = new StringBuffer().append(prefix).append(".layout").toString();
        appender = (Appender)OptionConverter.instantiateByKey(props, prefix, class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = PropertyConfigurator.class$("org.jetbrains.jet.internal.org.apache.log4j.Appender")) : class$org$apache$log4j$Appender, null);
        if (appender == null) {
            LogLog.error(new StringBuffer().append("Could not instantiate appender named \"").append(appenderName).append("\".").toString());
            return null;
        }
        appender.setName(appenderName);
        if (appender instanceof OptionHandler) {
            Layout layout;
            if (appender.requiresLayout() && (layout = (Layout)OptionConverter.instantiateByKey(props, layoutPrefix, class$org$apache$log4j$Layout == null ? (class$org$apache$log4j$Layout = PropertyConfigurator.class$("org.jetbrains.jet.internal.org.apache.log4j.Layout")) : class$org$apache$log4j$Layout, null)) != null) {
                appender.setLayout(layout);
                LogLog.debug(new StringBuffer().append("Parsing layout options for \"").append(appenderName).append("\".").toString());
                PropertySetter.setProperties(layout, props, new StringBuffer().append(layoutPrefix).append(".").toString());
                LogLog.debug(new StringBuffer().append("End of parsing for \"").append(appenderName).append("\".").toString());
            }
            PropertySetter.setProperties(appender, props, new StringBuffer().append(prefix).append(".").toString());
            LogLog.debug(new StringBuffer().append("Parsed \"").append(appenderName).append("\" options.").toString());
        }
        this.registryPut(appender);
        return appender;
    }

    void registryPut(Appender appender) {
        this.registry.put(appender.getName(), appender);
    }

    Appender registryGet(String name) {
        return (Appender)this.registry.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

