/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j;

import java.util.Date;
import org.jetbrains.jet.internal.org.apache.log4j.Layout;
import org.jetbrains.jet.internal.org.apache.log4j.Level;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.Transform;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LocationInfo;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggingEvent;

public class HTMLLayout
extends Layout {
    protected final int BUF_SIZE = 256;
    protected final int MAX_CAPACITY = 1024;
    static String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    private StringBuffer sbuf = new StringBuffer(256);
    public static final String LOCATION_INFO_OPTION = "LocationInfo";
    public static final String TITLE_OPTION = "Title";
    boolean locationInfo = false;
    String title = "Log4J Log Messages";

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public void activateOptions() {
    }

    @Override
    public String format(LoggingEvent event) {
        String[] s;
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        this.sbuf.append(new StringBuffer().append(Layout.LINE_SEP).append("<tr>").append(Layout.LINE_SEP).toString());
        this.sbuf.append("<td>");
        this.sbuf.append(event.timeStamp - LoggingEvent.getStartTime());
        this.sbuf.append(new StringBuffer().append("</td>").append(Layout.LINE_SEP).toString());
        this.sbuf.append(new StringBuffer().append("<td title=\"").append(event.getThreadName()).append(" thread\">").toString());
        this.sbuf.append(Transform.escapeTags(event.getThreadName()));
        this.sbuf.append(new StringBuffer().append("</td>").append(Layout.LINE_SEP).toString());
        this.sbuf.append("<td title=\"Level\">");
        if (event.level.equals(Level.DEBUG)) {
            this.sbuf.append("<font color=\"#339933\">");
            this.sbuf.append(event.level);
            this.sbuf.append("</font>");
        } else if (event.level.isGreaterOrEqual(Level.WARN)) {
            this.sbuf.append("<font color=\"#993300\"><strong>");
            this.sbuf.append(event.level);
            this.sbuf.append("</strong></font>");
        } else {
            this.sbuf.append(event.level);
        }
        this.sbuf.append(new StringBuffer().append("</td>").append(Layout.LINE_SEP).toString());
        this.sbuf.append(new StringBuffer().append("<td title=\"").append(event.categoryName).append(" category\">").toString());
        this.sbuf.append(Transform.escapeTags(event.categoryName));
        this.sbuf.append(new StringBuffer().append("</td>").append(Layout.LINE_SEP).toString());
        if (this.locationInfo) {
            LocationInfo locInfo = event.getLocationInformation();
            this.sbuf.append("<td>");
            this.sbuf.append(Transform.escapeTags(locInfo.getFileName()));
            this.sbuf.append(':');
            this.sbuf.append(locInfo.getLineNumber());
            this.sbuf.append(new StringBuffer().append("</td>").append(Layout.LINE_SEP).toString());
        }
        this.sbuf.append("<td title=\"Message\">");
        this.sbuf.append(Transform.escapeTags(event.getRenderedMessage()));
        this.sbuf.append(new StringBuffer().append("</td>").append(Layout.LINE_SEP).toString());
        this.sbuf.append(new StringBuffer().append("</tr>").append(Layout.LINE_SEP).toString());
        if (event.getNDC() != null) {
            this.sbuf.append("<tr><td bgcolor=\"#EEEEEE\" style=\"font-size : xx-small;\" colspan=\"6\" title=\"Nested Diagnostic Context\">");
            this.sbuf.append(new StringBuffer().append("NDC: ").append(Transform.escapeTags(event.getNDC())).toString());
            this.sbuf.append(new StringBuffer().append("</td></tr>").append(Layout.LINE_SEP).toString());
        }
        if ((s = event.getThrowableStrRep()) != null) {
            this.sbuf.append("<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : xx-small;\" colspan=\"6\">");
            this.appendThrowableAsHTML(s, this.sbuf);
            this.sbuf.append(new StringBuffer().append("</td></tr>").append(Layout.LINE_SEP).toString());
        }
        return this.sbuf.toString();
    }

    void appendThrowableAsHTML(String[] s, StringBuffer sbuf) {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            sbuf.append(Transform.escapeTags(s[0]));
            sbuf.append(Layout.LINE_SEP);
            int i = 1;
            while (i < len) {
                sbuf.append(TRACE_PREFIX);
                sbuf.append(Transform.escapeTags(s[i]));
                sbuf.append(Layout.LINE_SEP);
                ++i;
            }
        }
    }

    @Override
    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(new StringBuffer().append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<html>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<head>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<title>").append(this.title).append("</title>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<style type=\"text/css\">").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<!--").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("body, table {font-family: arial,sans-serif; font-size: x-small;}").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("th {background: #336699; color: #FFFFFF; text-align: left;}").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("-->").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("</style>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("</head>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\">").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<hr size=\"1\" noshade>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("Log session start time ").append(new Date()).append("<br>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<br>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<tr>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<th>Time</th>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<th>Thread</th>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<th>Level</th>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<th>Category</th>").append(Layout.LINE_SEP).toString());
        if (this.locationInfo) {
            sbuf.append(new StringBuffer().append("<th>File:Line</th>").append(Layout.LINE_SEP).toString());
        }
        sbuf.append(new StringBuffer().append("<th>Message</th>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("</tr>").append(Layout.LINE_SEP).toString());
        return sbuf.toString();
    }

    @Override
    public String getFooter() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(new StringBuffer().append("</table>").append(Layout.LINE_SEP).toString());
        sbuf.append(new StringBuffer().append("<br>").append(Layout.LINE_SEP).toString());
        sbuf.append("</body></html>");
        return sbuf.toString();
    }

    @Override
    public boolean ignoresThrowable() {
        return false;
    }
}

