/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.jet.internal.org.apache.log4j.FileAppender;
import org.jetbrains.jet.internal.org.apache.log4j.Layout;
import org.jetbrains.jet.internal.org.apache.log4j.RollingCalendar;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.LogLog;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggingEvent;

public class DailyRollingFileAppender
extends FileAppender {
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public DailyRollingFileAppender() {
    }

    public DailyRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    @Override
    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = new StringBuffer().append(this.fileName).append(this.sdf.format(new Date(file.lastModified()))).toString();
        } else {
            LogLog.error(new StringBuffer().append("Either Filename or DatePattern options are not set for [").append(this.name).append("].").toString());
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug(new StringBuffer().append("Appender [").append(this.name).append("] to be rolled every minute.").toString());
                break;
            }
            case 1: {
                LogLog.debug(new StringBuffer().append("Appender [").append(this.name).append("] to be rolled on top of every hour.").toString());
                break;
            }
            case 2: {
                LogLog.debug(new StringBuffer().append("Appender [").append(this.name).append("] to be rolled at midday and midnight.").toString());
                break;
            }
            case 3: {
                LogLog.debug(new StringBuffer().append("Appender [").append(this.name).append("] to be rolled at midnight.").toString());
                break;
            }
            case 4: {
                LogLog.debug(new StringBuffer().append("Appender [").append(this.name).append("] to be rolled at start of week.").toString());
                break;
            }
            case 5: {
                LogLog.debug(new StringBuffer().append("Appender [").append(this.name).append("] to be rolled at start of every month.").toString());
                break;
            }
            default: {
                LogLog.warn(new StringBuffer().append("Unknown periodicity for appender [").append(this.name).append("].").toString());
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            int i = 0;
            while (i <= 5) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 != null && r1 != null && !r0.equals(r1)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    void rollOver() throws IOException {
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = new StringBuffer().append(this.fileName).append(this.sdf.format(this.now)).toString();
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        File file = new File(this.fileName);
        file.renameTo(target);
        LogLog.debug(new StringBuffer().append(this.fileName).append(" -> ").append(this.scheduledFilename).toString());
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error(new StringBuffer().append("setFile(").append(this.fileName).append(", false) call failed.").toString());
        }
        this.scheduledFilename = datedFilename;
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                LogLog.error("rollOver() failed.", ioe);
            }
        }
        super.subAppend(event);
    }
}

