/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.org.apache.log4j;

import org.jetbrains.jet.internal.org.apache.log4j.Appender;
import org.jetbrains.jet.internal.org.apache.log4j.Layout;
import org.jetbrains.jet.internal.org.apache.log4j.Priority;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.LogLog;
import org.jetbrains.jet.internal.org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.jetbrains.jet.internal.org.apache.log4j.spi.ErrorHandler;
import org.jetbrains.jet.internal.org.apache.log4j.spi.Filter;
import org.jetbrains.jet.internal.org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.jet.internal.org.apache.log4j.spi.OptionHandler;

public abstract class AppenderSkeleton
implements Appender,
OptionHandler {
    protected Layout layout;
    protected String name;
    protected Priority threshold;
    protected ErrorHandler errorHandler = new OnlyOnceErrorHandler();
    protected Filter headFilter;
    protected Filter tailFilter;
    protected boolean closed = false;

    @Override
    public void activateOptions() {
    }

    @Override
    public void addFilter(Filter newFilter) {
        if (this.headFilter == null) {
            this.headFilter = this.tailFilter = newFilter;
        } else {
            this.tailFilter.next = newFilter;
            this.tailFilter = newFilter;
        }
    }

    protected abstract void append(LoggingEvent var1);

    @Override
    public void clearFilters() {
        this.tailFilter = null;
        this.headFilter = null;
    }

    public void finalize() {
        if (this.closed) {
            return;
        }
        LogLog.debug(new StringBuffer().append("Finalizing appender named [").append(this.name).append("].").toString());
        this.close();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public Filter getFilter() {
        return this.headFilter;
    }

    public final Filter getFirstFilter() {
        return this.headFilter;
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public Priority getThreshold() {
        return this.threshold;
    }

    public boolean isAsSevereAsThreshold(Priority priority) {
        return this.threshold == null || priority.isGreaterOrEqual(this.threshold);
    }

    @Override
    public synchronized void doAppend(LoggingEvent event) {
        if (this.closed) {
            LogLog.error(new StringBuffer().append("Attempted to append to closed appender named [").append(this.name).append("].").toString());
            return;
        }
        if (!this.isAsSevereAsThreshold(event.level)) {
            return;
        }
        Filter f = this.headFilter;
        block5: while (f != null) {
            switch (f.decide(event)) {
                case -1: {
                    return;
                }
                case 1: {
                    break block5;
                }
                case 0: {
                    f = f.next;
                }
                default: {
                    continue block5;
                }
            }
        }
        this.append(event);
    }

    @Override
    public synchronized void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            LogLog.warn("You have tried to set a null error-handler.");
        } else {
            this.errorHandler = eh;
        }
    }

    @Override
    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setThreshold(Priority threshold) {
        this.threshold = threshold;
    }

    @Override
    public abstract boolean requiresLayout();

    @Override
    public abstract void close();
}

