/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.gnu.trove.decorator;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.jet.internal.gnu.trove.TLongHashSet;
import org.jetbrains.jet.internal.gnu.trove.TLongIterator;

public class TLongHashSetDecorator
extends AbstractSet<Long>
implements Set<Long> {
    protected final TLongHashSet _set;

    public TLongHashSetDecorator(TLongHashSet set) {
        this._set = set;
    }

    @Override
    public boolean add(Long value) {
        return this._set.add(this.unwrap(value));
    }

    @Override
    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i = that.size();
            while (i-- > 0) {
                Object val = it.next();
                if (val instanceof Long) {
                    long v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public boolean remove(Object value) {
        return this._set.remove(this.unwrap(value));
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private final TLongIterator it;
            {
                this.it = TLongHashSetDecorator.this._set.iterator();
            }

            @Override
            public Long next() {
                return TLongHashSetDecorator.this.wrap(this.it.next());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Long wrap(long k) {
        return new Long(k);
    }

    protected long unwrap(Object value) {
        return (Long)value;
    }
}

