/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.gnu.trove.decorator;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.gnu.trove.TDoubleLongHashMap;
import org.jetbrains.jet.internal.gnu.trove.TDoubleLongIterator;

public class TDoubleLongHashMapDecorator
extends AbstractMap<Double, Long>
implements Map<Double, Long> {
    protected final TDoubleLongHashMap _map;

    public TDoubleLongHashMapDecorator(TDoubleLongHashMap map) {
        this._map = map;
    }

    @Override
    public Long put(Double key, Long value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Double && val instanceof Long) {
                    double k = this.unwrapKey(key);
                    long v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Long get(Double key) {
        double k = this.unwrapKey(key);
        long v = this._map.get(k);
        if (v == 0L) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Long remove(Double key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Double, Long>> entrySet() {
        return new AbstractSet<Map.Entry<Double, Long>>(){

            @Override
            public int size() {
                return TDoubleLongHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TDoubleLongHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TDoubleLongHashMapDecorator.this.containsKey(k) && ((Long)TDoubleLongHashMapDecorator.this.get(k)).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Double, Long>> iterator() {
                return new Iterator<Map.Entry<Double, Long>>(){
                    private final TDoubleLongIterator it;
                    {
                        this.it = TDoubleLongHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Double, Long> next() {
                        this.it.advance();
                        final Double key = TDoubleLongHashMapDecorator.this.wrapKey(this.it.key());
                        final Long v = TDoubleLongHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Double, Long>(){
                            private Long val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Double getKey() {
                                return key;
                            }

                            @Override
                            public Long getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Long setValue(Long value) {
                                this.val = value;
                                return TDoubleLongHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Long o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Double, Long>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TDoubleLongHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Long> map) {
        Iterator<Map.Entry<? extends Double, ? extends Long>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<? extends Double, ? extends Long> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Double wrapKey(double k) {
        return new Double(k);
    }

    protected double unwrapKey(Object key) {
        return (Double)key;
    }

    protected Long wrapValue(long k) {
        return new Long(k);
    }

    protected long unwrapValue(Object value) {
        return (Long)value;
    }
}

