/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.gnu.trove.benchmark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jetbrains.jet.internal.gnu.trove.THashMap;
import org.jetbrains.jet.internal.gnu.trove.THashSet;
import org.jetbrains.jet.internal.gnu.trove.TIntIntHashMap;
import org.jetbrains.jet.internal.gnu.trove.TLinkableAdaptor;
import org.jetbrains.jet.internal.gnu.trove.TLinkedList;
import org.jetbrains.jet.internal.gnu.trove.TObjectProcedure;
import org.jetbrains.jet.internal.gnu.trove.benchmark.Operation;
import org.jetbrains.jet.internal.gnu.trove.benchmark.Repeater;
import org.jetbrains.jet.internal.gnu.trove.benchmark.TextReporter;

public class Main {
    static final List dataset = new ArrayList(100000);

    public static Operation getAddRemoveOperation() {
        return new Operation(){
            private Set theirSet = this.prepareSet(new HashSet(100000));
            private Set ourSet = this.prepareSet(new THashSet(100000));

            @Override
            public void theirs() {
                this.testSet(this.theirSet);
            }

            @Override
            public void ours() {
                this.testSet(this.ourSet);
            }

            private void testSet(Set s) {
                for (Object data : dataset) {
                    s.contains(data);
                }
            }

            private Set prepareSet(Set s) {
                int chunks = 10;
                int chunkSize = 100000;
                for (int chunk = 0; chunk < chunks; ++chunk) {
                    int i;
                    int start = chunk * chunkSize;
                    int end = (chunk + 1) * chunkSize - 1;
                    for (i = start; i < end; ++i) {
                        s.add(new Integer(i));
                    }
                    for (i = start; i < end; ++i) {
                        s.remove(new Integer(i));
                    }
                }
                return s;
            }

            @Override
            public int getIterationCount() {
                return 10;
            }

            public String toString() {
                return "Performance degradation after many removes";
            }
        };
    }

    public static Operation getSetOperation() {
        return new Operation(){

            @Override
            public void theirs() {
                HashSet s = new HashSet(100000);
                Iterator i = dataset.iterator();
                while (i.hasNext()) {
                    s.add(i.next());
                }
            }

            @Override
            public void ours() {
                THashSet s = new THashSet(100000);
                Iterator i = dataset.iterator();
                while (i.hasNext()) {
                    s.add(i.next());
                }
            }

            public String toString() {
                return "compares " + dataset.size() + " Set.add() operations";
            }

            @Override
            public int getIterationCount() {
                return 10;
            }
        };
    }

    public static Operation getLinkedListAddOp() {
        final ArrayList<TLinkableAdaptor> data = new ArrayList<TLinkableAdaptor>(100000);
        for (int i = 0; i < 100000; ++i) {
            data.add(new TLinkableAdaptor());
        }
        return new Operation(){

            @Override
            public void theirs() {
                LinkedList l = new LinkedList();
                Iterator i = data.iterator();
                while (i.hasNext()) {
                    l.add(i.next());
                }
            }

            @Override
            public void ours() {
                TLinkedList l = new TLinkedList();
                Iterator i = data.iterator();
                while (i.hasNext()) {
                    l.add(i.next());
                }
            }

            public String toString() {
                return "compares " + dataset.size() + " LinkedList.add() operations";
            }

            @Override
            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getContainsOp() {
        final HashSet theirs = new HashSet(dataset.size());
        theirs.addAll(dataset);
        final THashSet ours = new THashSet(dataset.size());
        ours.addAll(dataset);
        return new Operation(){

            @Override
            public void theirs() {
                for (int i = 0; i < dataset.size(); i += 5) {
                    theirs.contains(dataset.get(i));
                }
            }

            @Override
            public void ours() {
                for (int i = 0; i < dataset.size(); i += 5) {
                    ours.contains(dataset.get(i));
                }
            }

            public String toString() {
                return "compares " + dataset.size() / 5 + " Set.contains() operations";
            }

            @Override
            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getRandomSetContainsOp() {
        final HashSet<Integer> theirs = new HashSet<Integer>(100000);
        final THashSet<Integer> ours = new THashSet<Integer>(100000);
        Random rand = new Random(9999L);
        for (int i = 0; i < 100000; ++i) {
            Integer x = new Integer(rand.nextInt());
            theirs.add(x);
            ours.add(x);
        }
        Random rand2 = new Random(9998L);
        final ArrayList<Integer> query = new ArrayList<Integer>(100000);
        int match = 0;
        for (int i = 0; i < 100000; ++i) {
            Integer x = new Integer(rand.nextInt());
            query.add(x);
            if (!theirs.contains(x)) continue;
            ++match;
        }
        final int success = match;
        return new Operation(){

            @Override
            public void theirs() {
                Iterator i = query.iterator();
                while (i.hasNext()) {
                    theirs.contains(i.next());
                }
            }

            @Override
            public void ours() {
                Iterator i = query.iterator();
                while (i.hasNext()) {
                    ours.contains(i.next());
                }
            }

            public String toString() {
                return "compares 100000 Set.contains() operations. " + success + " are actually present in set";
            }

            @Override
            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getMapPutOp() {
        return new Operation(){

            @Override
            public void theirs() {
                HashMap theirs = new HashMap(dataset.size());
                for (Object o : dataset) {
                    theirs.put(o, o);
                }
            }

            @Override
            public void ours() {
                THashMap ours = new THashMap(dataset.size());
                for (Object o : dataset) {
                    ours.put(o, o);
                }
            }

            public String toString() {
                return "compares " + dataset.size() + " Map.put() operations";
            }

            @Override
            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getIterationOp() {
        final HashMap theirMap = new HashMap(dataset.size());
        final THashMap ourMap = new THashMap(dataset.size());
        for (Object o : dataset) {
            theirMap.put(o, o);
            ourMap.put(o, o);
        }
        return new Operation(){

            @Override
            public void theirs() {
                Map m = theirMap;
                Iterator i = m.keySet().iterator();
                int size = m.size();
                while (size-- > 0) {
                    Object k = i.next();
                }
            }

            @Override
            public void ours() {
                Map m = ourMap;
                Iterator i = m.keySet().iterator();
                int size = m.size();
                while (size-- > 0) {
                    Object k = i.next();
                }
            }

            public String toString() {
                return "compares Iterator.next() over " + dataset.size() + " map keys";
            }

            @Override
            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getIterationWithHasNextOp() {
        final HashMap theirMap = new HashMap(dataset.size());
        final THashMap ourMap = new THashMap(dataset.size());
        for (Object o : dataset) {
            theirMap.put(o, o);
            ourMap.put(o, o);
        }
        return new Operation(){

            @Override
            public void theirs() {
                Map m = theirMap;
                for (Object k : m.keySet()) {
                }
            }

            @Override
            public void ours() {
                Map m = ourMap;
                for (Object k : m.keySet()) {
                }
            }

            public String toString() {
                return "compares Iterator.hasNext()/ Iterator.next() over " + theirMap.size() + " keys";
            }

            @Override
            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getIntMapPut() {
        return new Operation(){

            @Override
            public void theirs() {
            }

            @Override
            public void ours() {
                TIntIntHashMap ours = new TIntIntHashMap(100000);
                int i = dataset.size();
                while (i-- > 0) {
                    ours.put(i, i);
                }
            }

            public String toString() {
                return dataset.size() + " entry primitive int map.put timing run; no basis for comparison";
            }

            @Override
            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getSumSetOperation() {
        final HashSet theirSet = new HashSet(dataset.size());
        final THashSet ourSet = new THashSet(dataset.size());
        theirSet.addAll(dataset);
        ourSet.addAll(dataset);
        final TObjectProcedure proc = new TObjectProcedure(){
            int sum = 0;

            public boolean execute(Object o) {
                this.sum += ((Integer)o).intValue();
                return true;
            }
        };
        return new Operation(){

            @Override
            public void theirs() {
                int sum = 0;
                Iterator i = theirSet.iterator();
                while (i.hasNext()) {
                    sum += ((Integer)i.next()).intValue();
                }
            }

            @Override
            public void ours() {
                ourSet.forEach(proc);
            }

            public String toString() {
                return "sums a " + theirSet.size() + " element Set of Integer objects.  Their approach uses Iterator.hasNext()/next(); ours uses THashSet.forEach(TObjectProcedure)";
            }

            @Override
            public int getIterationCount() {
                return 10;
            }
        };
    }

    public static void main(String[] args) {
        TextReporter reporter = new TextReporter();
        reporter.start();
        Operation op = Main.getRandomSetContainsOp();
        Repeater t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getSumSetOperation();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getIterationWithHasNextOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getIterationOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getLinkedListAddOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getIntMapPut();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getMapPutOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getContainsOp();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getSetOperation();
        t = new Repeater(op);
        reporter.report(t.run());
        op = Main.getAddRemoveOperation();
        t = new Repeater(op);
        reporter.report(t.run());
        reporter.finish();
    }

    static {
        for (int i = 0; i < 100000; ++i) {
            dataset.add(new Integer(i));
        }
    }
}

