/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.gnu.trove;

import java.io.Serializable;
import org.jetbrains.jet.internal.gnu.trove.TFloatFunction;
import org.jetbrains.jet.internal.gnu.trove.TFloatProcedure;
import org.jetbrains.jet.internal.gnu.trove.TObjectFloatIterator;
import org.jetbrains.jet.internal.gnu.trove.TObjectFloatProcedure;
import org.jetbrains.jet.internal.gnu.trove.TObjectHash;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashingStrategy;
import org.jetbrains.jet.internal.gnu.trove.TObjectProcedure;

public class TObjectFloatHashMap<K>
extends TObjectHash<K>
implements Serializable {
    protected transient float[] _values;

    public TObjectFloatHashMap() {
    }

    public TObjectFloatHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectFloatHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectFloatHashMap(TObjectHashingStrategy<K> strategy) {
        super(strategy);
    }

    public TObjectFloatHashMap(int initialCapacity, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectFloatHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectFloatIterator<K> iterator() {
        return new TObjectFloatIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new float[capacity];
        return capacity;
    }

    public float put(K key, float value) {
        float previous = 0.0f;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        float[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new float[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public float get(K key) {
        int index = this.index(key);
        return index < 0 ? 0.0f : this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys = this._set;
        float[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = null;
            vals[i] = 0.0f;
        }
    }

    public float remove(K key) {
        float prev = 0.0f;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectFloatHashMap)) {
            return false;
        }
        TObjectFloatHashMap that = (TObjectFloatHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = 0.0f;
        super.removeAt(index);
    }

    public float[] getValues() {
        float[] vals = new float[this.size()];
        float[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == null || k[i] == REMOVED) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(float val) {
        Object[] keys = this._set;
        float[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K key) {
        return this.contains(key);
    }

    public boolean forEachKey(TObjectProcedure<K> procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TFloatProcedure procedure) {
        Object[] keys = this._set;
        float[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectFloatProcedure<K> procedure) {
        Object[] keys = this._set;
        float[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TObjectFloatProcedure<K> procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        float[] values = this._values;
        this.stopCompactingOnRemove();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TFloatFunction function) {
        Object[] keys = this._set;
        float[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(K key) {
        return this.adjustValue(key, 1.0f);
    }

    public boolean adjustValue(K key, float amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private static final class EqProcedure
    implements TObjectFloatProcedure {
        private final TObjectFloatHashMap _otherMap;

        EqProcedure(TObjectFloatHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(Object key, float value) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static final boolean eq(float v1, float v2) {
            return v1 == v2;
        }
    }
}

