/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.gnu.trove;

import java.util.ConcurrentModificationException;
import org.jetbrains.jet.internal.gnu.trove.TIterator;
import org.jetbrains.jet.internal.gnu.trove.TObjectDoubleHashMap;
import org.jetbrains.jet.internal.gnu.trove.TObjectHash;

public class TObjectDoubleIterator<K>
extends TIterator {
    private final TObjectDoubleHashMap<K> _map;

    public TObjectDoubleIterator(TObjectDoubleHashMap<K> map) {
        super(map);
        this._map = map;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == null || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public K key() {
        return (K)this._map._set[this._index];
    }

    public double value() {
        return this._map._values[this._index];
    }

    public double setValue(double val) {
        double old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

