/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.gnu.trove;

import java.io.Serializable;
import org.jetbrains.jet.internal.gnu.trove.HashFunctions;
import org.jetbrains.jet.internal.gnu.trove.TDoubleFunction;
import org.jetbrains.jet.internal.gnu.trove.TDoubleProcedure;
import org.jetbrains.jet.internal.gnu.trove.TIntDoubleIterator;
import org.jetbrains.jet.internal.gnu.trove.TIntDoubleProcedure;
import org.jetbrains.jet.internal.gnu.trove.TIntHash;
import org.jetbrains.jet.internal.gnu.trove.TIntHashingStrategy;
import org.jetbrains.jet.internal.gnu.trove.TIntProcedure;

public class TIntDoubleHashMap
extends TIntHash
implements Serializable {
    protected transient double[] _values;

    public TIntDoubleHashMap() {
    }

    public TIntDoubleHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TIntDoubleHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TIntDoubleHashMap(TIntHashingStrategy strategy) {
        super(strategy);
    }

    public TIntDoubleHashMap(int initialCapacity, TIntHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TIntDoubleHashMap(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    @Override
    public Object clone() {
        TIntDoubleHashMap m = (TIntDoubleHashMap)super.clone();
        m._values = (double[])this._values.clone();
        return m;
    }

    public TIntDoubleIterator iterator() {
        return new TIntDoubleIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new double[capacity];
        return capacity;
    }

    public double put(int key, double value) {
        double previous = 0.0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldKeys = this._set;
        double[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._values = new double[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            int o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public double get(int key) {
        int index = this.index(key);
        return index < 0 ? 0.0 : this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        int[] keys = this._set;
        double[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0;
            vals[i] = 0.0;
            states[i] = 0;
        }
    }

    public double remove(int key) {
        double prev = 0.0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntDoubleHashMap)) {
            return false;
        }
        TIntDoubleHashMap that = (TIntDoubleHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = 0.0;
        super.removeAt(index);
    }

    public double[] getValues() {
        double[] vals = new double[this.size()];
        double[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public int[] keys() {
        int[] keys = new int[this.size()];
        int[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(double val) {
        byte[] states = this._states;
        double[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int key) {
        return this.contains(key);
    }

    public boolean forEachKey(TIntProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TDoubleProcedure procedure) {
        byte[] states = this._states;
        double[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntDoubleProcedure procedure) {
        byte[] states = this._states;
        int[] keys = this._set;
        double[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TIntDoubleProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        int[] keys = this._set;
        double[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TDoubleFunction function) {
        byte[] states = this._states;
        double[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(int key) {
        return this.adjustValue(key, 1.0);
    }

    public boolean adjustValue(int key, double amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private static final class EqProcedure
    implements TIntDoubleProcedure {
        private final TIntDoubleHashMap _otherMap;

        EqProcedure(TIntDoubleHashMap otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(int key, double value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(double v1, double v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TIntDoubleProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(int key, double value) {
            this.h += TIntDoubleHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

