/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.gnu.trove;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.jet.internal.gnu.trove.TObjectHash;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashIterator;
import org.jetbrains.jet.internal.gnu.trove.TObjectHashingStrategy;
import org.jetbrains.jet.internal.gnu.trove.TObjectProcedure;
import org.jetbrains.jet.internal.gnu.trove.ToObjectArrayProcedure;

public class THashSet<E>
extends TObjectHash<E>
implements Serializable,
Set<E> {
    public THashSet() {
    }

    public THashSet(TObjectHashingStrategy<E> strategy) {
        super(strategy);
    }

    public THashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public THashSet(int initialCapacity, TObjectHashingStrategy<E> strategy) {
        super(initialCapacity, strategy);
    }

    public THashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public THashSet(int initialCapacity, float loadFactor, TObjectHashingStrategy<E> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public THashSet(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public THashSet(Collection<? extends E> collection, TObjectHashingStrategy<E> strategy) {
        this(collection.size(), strategy);
        this.addAll(collection);
    }

    @Override
    public boolean add(E obj) {
        int index = this.insertionIndex(obj);
        if (index < 0) {
            return false;
        }
        Object old = this._set[index];
        this._set[index] = obj;
        this.postInsertHook(old == null);
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.containsAll(that);
    }

    @Override
    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldSet = this._set;
        this._set = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == REMOVED) continue;
            Object o = oldSet[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        this.forEach(new ToObjectArrayProcedure<Object>(result));
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        T[] result = a;
        Iterator<E> it = this.iterator();
        for (int i = 0; i < size; ++i) {
            result[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public void clear() {
        super.clear();
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            set[i] = null;
        }
    }

    @Override
    public boolean remove(Object obj) {
        int index = this.index(obj);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new TObjectHashIterator(this);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> i = collection.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        int size = collection.size();
        this.ensureCapacity(size);
        Iterator<E> it = collection.iterator();
        while (size-- > 0) {
            if (!this.add(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        int size = collection.size();
        Iterator<?> it = collection.iterator();
        while (size-- > 0) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        int size = this.size();
        Iterator<E> it = this.iterator();
        while (size-- > 0) {
            if (collection.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    private final class HashProcedure
    implements TObjectProcedure<E> {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(E key) {
            this.h += THashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

