/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.gnu.trove;

import java.io.Serializable;
import org.jetbrains.jet.internal.gnu.trove.HashFunctions;
import org.jetbrains.jet.internal.gnu.trove.TFloatHash;
import org.jetbrains.jet.internal.gnu.trove.TFloatHashingStrategy;
import org.jetbrains.jet.internal.gnu.trove.TFloatIntIterator;
import org.jetbrains.jet.internal.gnu.trove.TFloatIntProcedure;
import org.jetbrains.jet.internal.gnu.trove.TFloatProcedure;
import org.jetbrains.jet.internal.gnu.trove.TIntFunction;
import org.jetbrains.jet.internal.gnu.trove.TIntProcedure;

public class TFloatIntHashMap
extends TFloatHash
implements Serializable {
    protected transient int[] _values;

    public TFloatIntHashMap() {
    }

    public TFloatIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TFloatIntHashMap(TFloatHashingStrategy strategy) {
        super(strategy);
    }

    public TFloatIntHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TFloatIntHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    @Override
    public Object clone() {
        TFloatIntHashMap m = (TFloatIntHashMap)super.clone();
        m._values = (int[])this._values.clone();
        return m;
    }

    public TFloatIntIterator iterator() {
        return new TFloatIntIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new int[capacity];
        return capacity;
    }

    public int put(float key, int value) {
        int previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        float[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new float[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            float o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public int get(float key) {
        int index = this.index(key);
        return index < 0 ? 0 : this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        float[] keys = this._set;
        int[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0.0f;
            vals[i] = 0;
            states[i] = 0;
        }
    }

    public int remove(float key) {
        int prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatIntHashMap)) {
            return false;
        }
        TFloatIntHashMap that = (TFloatIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = 0;
        super.removeAt(index);
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public float[] keys() {
        float[] keys = new float[this.size()];
        float[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatIntProcedure procedure) {
        byte[] states = this._states;
        float[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TFloatIntProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        float[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TIntFunction function) {
        byte[] states = this._states;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(float key) {
        return this.adjustValue(key, 1);
    }

    public boolean adjustValue(float key, int amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private static final class EqProcedure
    implements TFloatIntProcedure {
        private final TFloatIntHashMap _otherMap;

        EqProcedure(TFloatIntHashMap otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(float key, int value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(int v1, int v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TFloatIntProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(float key, int value) {
            this.h += TFloatIntHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

