/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.alias.ClassMapper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.MapperWrapper;

public class ImplicitCollectionMapper
extends MapperWrapper {
    private final Map classNameToMapper = new HashMap();

    public ImplicitCollectionMapper(Mapper wrapped) {
        super(wrapped);
    }

    public ImplicitCollectionMapper(ClassMapper wrapped) {
        this((Mapper)wrapped);
    }

    private ImplicitCollectionMapperForClass getMapper(Class definedIn) {
        while (definedIn != null) {
            ImplicitCollectionMapperForClass mapper = (ImplicitCollectionMapperForClass)this.classNameToMapper.get(definedIn);
            if (mapper != null) {
                return mapper;
            }
            definedIn = definedIn.getSuperclass();
        }
        return null;
    }

    private ImplicitCollectionMapperForClass getOrCreateMapper(Class definedIn) {
        ImplicitCollectionMapperForClass mapper = this.getMapper(definedIn);
        if (mapper == null) {
            mapper = new ImplicitCollectionMapperForClass();
            this.classNameToMapper.put(definedIn, mapper);
        }
        return mapper;
    }

    @Override
    public String getFieldNameForItemTypeAndName(Class definedIn, Class itemType, String itemFieldName) {
        ImplicitCollectionMapperForClass mapper = this.getMapper(definedIn);
        if (mapper != null) {
            return mapper.getFieldNameForItemTypeAndName(itemType, itemFieldName);
        }
        return null;
    }

    @Override
    public Class getItemTypeForItemFieldName(Class definedIn, String itemFieldName) {
        ImplicitCollectionMapperForClass mapper = this.getMapper(definedIn);
        if (mapper != null) {
            return mapper.getItemTypeForItemFieldName(itemFieldName);
        }
        return null;
    }

    @Override
    public Mapper.ImplicitCollectionMapping getImplicitCollectionDefForFieldName(Class itemType, String fieldName) {
        ImplicitCollectionMapperForClass mapper = this.getMapper(itemType);
        if (mapper != null) {
            return mapper.getImplicitCollectionDefForFieldName(fieldName);
        }
        return null;
    }

    public void add(Class definedIn, String fieldName, Class itemType) {
        this.add(definedIn, fieldName, null, itemType);
    }

    public void add(Class definedIn, String fieldName, String itemFieldName, Class itemType) {
        ImplicitCollectionMapperForClass mapper = this.getOrCreateMapper(definedIn);
        mapper.add(new ImplicitCollectionMappingImpl(fieldName, itemType, itemFieldName));
    }

    private static class NamedItemType {
        Class itemType;
        String itemFieldName;

        NamedItemType(Class itemType, String itemFieldName) {
            this.itemType = itemType;
            this.itemFieldName = itemFieldName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NamedItemType) {
                NamedItemType b = (NamedItemType)obj;
                return this.itemType.equals(b.itemType) && NamedItemType.isEquals(this.itemFieldName, b.itemFieldName);
            }
            return false;
        }

        private static boolean isEquals(Object a, Object b) {
            if (a == null) {
                return b == null;
            }
            return a.equals(b);
        }

        public int hashCode() {
            int hash = this.itemType.hashCode() << 7;
            if (this.itemFieldName != null) {
                hash += this.itemFieldName.hashCode();
            }
            return hash;
        }
    }

    private static class ImplicitCollectionMappingImpl
    implements Mapper.ImplicitCollectionMapping {
        private String fieldName;
        private String itemFieldName;
        private Class itemType;

        ImplicitCollectionMappingImpl(String fieldName, Class itemType, String itemFieldName) {
            this.fieldName = fieldName;
            this.itemFieldName = itemFieldName;
            this.itemType = itemType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ImplicitCollectionMappingImpl) {
                ImplicitCollectionMappingImpl b = (ImplicitCollectionMappingImpl)obj;
                return this.fieldName.equals(b.fieldName) && ImplicitCollectionMappingImpl.isEquals(this.itemFieldName, b.itemFieldName);
            }
            return false;
        }

        public NamedItemType createNamedItemType() {
            return new NamedItemType(this.itemType, this.itemFieldName);
        }

        private static boolean isEquals(Object a, Object b) {
            if (a == null) {
                return b == null;
            }
            return a.equals(b);
        }

        public int hashCode() {
            int hash = this.fieldName.hashCode();
            if (this.itemFieldName != null) {
                hash += this.itemFieldName.hashCode() << 7;
            }
            return hash;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String getItemFieldName() {
            return this.itemFieldName;
        }

        @Override
        public Class getItemType() {
            return this.itemType;
        }
    }

    private static class ImplicitCollectionMapperForClass {
        private Map namedItemTypeToDef = new HashMap();
        private Map itemFieldNameToDef = new HashMap();
        private Map fieldNameToDef = new HashMap();

        private ImplicitCollectionMapperForClass() {
        }

        public String getFieldNameForItemTypeAndName(Class itemType, String itemFieldName) {
            ImplicitCollectionMappingImpl unnamed = null;
            for (NamedItemType itemTypeForFieldName : this.namedItemTypeToDef.keySet()) {
                if (!itemTypeForFieldName.itemType.isAssignableFrom(itemType)) continue;
                ImplicitCollectionMappingImpl def = (ImplicitCollectionMappingImpl)this.namedItemTypeToDef.get(itemTypeForFieldName);
                if (def.getItemFieldName() != null) {
                    if (!def.getItemFieldName().equals(itemFieldName)) continue;
                    return def.getFieldName();
                }
                unnamed = def;
                if (itemFieldName != null) continue;
                break;
            }
            return unnamed != null ? unnamed.getFieldName() : null;
        }

        public Class getItemTypeForItemFieldName(String itemFieldName) {
            ImplicitCollectionMappingImpl def = this.getImplicitCollectionDefByItemFieldName(itemFieldName);
            if (def != null) {
                return def.getItemType();
            }
            return null;
        }

        private ImplicitCollectionMappingImpl getImplicitCollectionDefByItemFieldName(String itemFieldName) {
            if (itemFieldName == null) {
                return null;
            }
            return (ImplicitCollectionMappingImpl)this.itemFieldNameToDef.get(itemFieldName);
        }

        public ImplicitCollectionMappingImpl getImplicitCollectionDefByFieldName(String fieldName) {
            return (ImplicitCollectionMappingImpl)this.fieldNameToDef.get(fieldName);
        }

        public Mapper.ImplicitCollectionMapping getImplicitCollectionDefForFieldName(String fieldName) {
            return (Mapper.ImplicitCollectionMapping)this.fieldNameToDef.get(fieldName);
        }

        public void add(ImplicitCollectionMappingImpl def) {
            this.fieldNameToDef.put(def.getFieldName(), def);
            this.namedItemTypeToDef.put(def.createNamedItemType(), def);
            if (def.getItemFieldName() != null) {
                this.itemFieldNameToDef.put(def.getItemFieldName(), def);
            }
        }
    }
}

