/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper;

import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.SingleValueConverter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.CannotResolveClassException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class DefaultMapper
implements Mapper {
    private final ClassLoader classLoader;
    private transient String classAttributeIdentifier;

    public DefaultMapper(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classAttributeIdentifier = "class";
    }

    public DefaultMapper(ClassLoader classLoader, String classAttributeIdentifier) {
        this(classLoader);
        this.classAttributeIdentifier = classAttributeIdentifier == null ? "class" : classAttributeIdentifier;
    }

    @Override
    public String serializedClass(Class type) {
        return type.getName();
    }

    @Override
    public Class realClass(String elementName) {
        try {
            return this.classLoader.loadClass(elementName);
        }
        catch (ClassNotFoundException e) {
            throw new CannotResolveClassException(new StringBuffer().append(elementName).append(" : ").append(e.getMessage()).toString());
        }
    }

    @Override
    public Class defaultImplementationOf(Class type) {
        return type;
    }

    @Override
    public String attributeForClassDefiningField() {
        return "defined-in";
    }

    @Override
    public String attributeForReadResolveField() {
        return "resolves-to";
    }

    @Override
    public String attributeForEnumType() {
        return "enum-type";
    }

    @Override
    public String attributeForImplementationClass() {
        return this.classAttributeIdentifier;
    }

    @Override
    public String aliasForAttribute(String attribute) {
        return attribute;
    }

    @Override
    public String attributeForAlias(String alias) {
        return alias;
    }

    @Override
    public boolean isImmutableValueType(Class type) {
        return false;
    }

    @Override
    public String getFieldNameForItemTypeAndName(Class definedIn, Class itemType, String itemFieldName) {
        return null;
    }

    @Override
    public Class getItemTypeForItemFieldName(Class definedIn, String itemFieldName) {
        return null;
    }

    @Override
    public Mapper.ImplicitCollectionMapping getImplicitCollectionDefForFieldName(Class itemType, String fieldName) {
        return null;
    }

    @Override
    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        return true;
    }

    public String lookupName(Class type) {
        return this.serializedClass(type);
    }

    public Class lookupType(String elementName) {
        return this.realClass(elementName);
    }

    @Override
    public String serializedMember(Class type, String memberName) {
        return memberName;
    }

    @Override
    public String realMember(Class type, String serialized) {
        return serialized;
    }

    @Override
    public SingleValueConverter getConverterFromAttribute(String name) {
        return null;
    }

    @Override
    public SingleValueConverter getConverterFromItemType(String fieldName, Class type) {
        return null;
    }

    @Override
    public SingleValueConverter getConverterFromItemType(Class type) {
        return null;
    }

    @Override
    public Mapper lookupMapperOfType(Class type) {
        return null;
    }
}

