/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.alias.ClassMapper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.MapperWrapper;

public class ClassAliasingMapper
extends MapperWrapper {
    protected final Map typeToName = new HashMap();
    protected final Map classToName = new HashMap();
    protected transient Map nameToType = new HashMap();
    protected final Set knownAttributes = new HashSet();

    public ClassAliasingMapper(Mapper wrapped) {
        super(wrapped);
    }

    public ClassAliasingMapper(ClassMapper wrapped) {
        this((Mapper)wrapped);
    }

    public void addClassAlias(String name, Class type) {
        this.nameToType.put(name, type.getName());
        this.classToName.put(type.getName(), name);
    }

    public void addClassAttributeAlias(String name, Class type) {
        this.addClassAlias(name, type);
        this.knownAttributes.add(name);
    }

    public void addTypeAlias(String name, Class type) {
        this.nameToType.put(name, type.getName());
        this.typeToName.put(type, name);
    }

    @Override
    public String serializedClass(Class type) {
        String alias = (String)this.classToName.get(type.getName());
        if (alias != null) {
            return alias;
        }
        for (Class compatibleType : this.typeToName.keySet()) {
            if (!compatibleType.isAssignableFrom(type)) continue;
            return (String)this.typeToName.get(compatibleType);
        }
        return super.serializedClass(type);
    }

    @Override
    public Class realClass(String elementName) {
        String mappedName = (String)this.nameToType.get(elementName);
        if (mappedName != null) {
            elementName = mappedName;
        }
        return super.realClass(elementName);
    }

    public boolean itemTypeAsAttribute(Class clazz) {
        return this.classToName.containsKey(clazz);
    }

    public boolean aliasIsAttribute(String name) {
        return this.nameToType.containsKey(name);
    }
}

