/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.XppReader;

public class XppDriver
extends AbstractXmlDriver {
    private static boolean xppLibraryPresent;

    public XppDriver() {
        super(new XmlFriendlyReplacer());
    }

    public XppDriver(XmlFriendlyReplacer replacer) {
        super(replacer);
    }

    @Override
    public HierarchicalStreamReader createReader(Reader xml) {
        this.loadLibrary();
        return new XppReader(xml, this.xmlFriendlyReplacer());
    }

    @Override
    public HierarchicalStreamReader createReader(InputStream in) {
        return this.createReader(new InputStreamReader(in));
    }

    private void loadLibrary() {
        if (!xppLibraryPresent) {
            try {
                Class.forName("org.jetbrains.jet.internal.org.xmlpull.mxp1.MXParser");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("XPP3 pull parser library not present. Specify another driver. For example: new XStream(new DomDriver())");
            }
            xppLibraryPresent = true;
        }
    }

    @Override
    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.xmlFriendlyReplacer());
    }

    @Override
    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }
}

