/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml;

import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.AbstractDocumentReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.xppdom.Xpp3Dom;

public class XppDomReader
extends AbstractDocumentReader {
    private Xpp3Dom currentElement;

    public XppDomReader(Xpp3Dom xpp3Dom) {
        super(xpp3Dom);
    }

    public XppDomReader(Xpp3Dom xpp3Dom, XmlFriendlyReplacer replacer) {
        super(xpp3Dom, replacer);
    }

    @Override
    public String getNodeName() {
        return this.unescapeXmlName(this.currentElement.getName());
    }

    @Override
    public String getValue() {
        String text = null;
        try {
            text = this.currentElement.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text == null ? "" : text;
    }

    @Override
    public String getAttribute(String attributeName) {
        return this.currentElement.getAttribute(attributeName);
    }

    @Override
    public String getAttribute(int index) {
        return this.currentElement.getAttribute(this.currentElement.getAttributeNames()[index]);
    }

    @Override
    public int getAttributeCount() {
        return this.currentElement.getAttributeNames().length;
    }

    @Override
    public String getAttributeName(int index) {
        return this.unescapeXmlName(this.currentElement.getAttributeNames()[index]);
    }

    @Override
    protected Object getParent() {
        return this.currentElement.getParent();
    }

    @Override
    protected Object getChild(int index) {
        return this.currentElement.getChild(index);
    }

    @Override
    protected int getChildCount() {
        return this.currentElement.getChildCount();
    }

    @Override
    protected void reassignCurrentElement(Object current) {
        this.currentElement = (Xpp3Dom)current;
    }
}

