/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.StreamException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.XppDomReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.xppdom.Xpp3DomBuilder;

public class XppDomDriver
extends AbstractXmlDriver {
    public XppDomDriver() {
        super(new XmlFriendlyReplacer());
    }

    public XppDomDriver(XmlFriendlyReplacer replacer) {
        super(replacer);
    }

    @Override
    public HierarchicalStreamReader createReader(Reader xml) {
        try {
            return new XppDomReader(Xpp3DomBuilder.build(xml), this.xmlFriendlyReplacer());
        }
        catch (Exception e) {
            throw new StreamException(e);
        }
    }

    @Override
    public HierarchicalStreamReader createReader(InputStream in) {
        return this.createReader(new InputStreamReader(in));
    }

    @Override
    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.xmlFriendlyReplacer());
    }

    @Override
    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }
}

