/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ErrorWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.StreamException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.AbstractPullReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.QNameMap;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public class StaxReader
extends AbstractPullReader {
    private final QNameMap qnameMap;
    private final XMLStreamReader in;

    public StaxReader(QNameMap qnameMap, XMLStreamReader in) {
        this(qnameMap, in, new XmlFriendlyReplacer());
    }

    public StaxReader(QNameMap qnameMap, XMLStreamReader in, XmlFriendlyReplacer replacer) {
        super(replacer);
        this.qnameMap = qnameMap;
        this.in = in;
        this.moveDown();
    }

    @Override
    protected int pullNextEvent() {
        try {
            switch (this.in.next()) {
                case 1: 
                case 7: {
                    return 1;
                }
                case 2: 
                case 8: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
            }
            return 0;
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    @Override
    protected String pullElementName() {
        QName qname = this.in.getName();
        return this.qnameMap.getJavaClassName(qname);
    }

    @Override
    protected String pullText() {
        return this.in.getText();
    }

    @Override
    public String getAttribute(String name) {
        return this.in.getAttributeValue(null, name);
    }

    @Override
    public String getAttribute(int index) {
        return this.in.getAttributeValue(index);
    }

    @Override
    public int getAttributeCount() {
        return this.in.getAttributeCount();
    }

    @Override
    public String getAttributeName(int index) {
        return this.unescapeXmlName(this.in.getAttributeLocalName(index));
    }

    @Override
    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("line number", String.valueOf(this.in.getLocation().getLineNumber()));
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }
}

