/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml;

import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.AbstractDocumentReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import org.jetbrains.jet.internal.org.jdom.Attribute;
import org.jetbrains.jet.internal.org.jdom.Document;
import org.jetbrains.jet.internal.org.jdom.Element;

public class JDomReader
extends AbstractDocumentReader {
    private Element currentElement;

    public JDomReader(Element root) {
        super(root);
    }

    public JDomReader(Document document) {
        super(document.getRootElement());
    }

    public JDomReader(Element root, XmlFriendlyReplacer replacer) {
        super(root, replacer);
    }

    public JDomReader(Document document, XmlFriendlyReplacer replacer) {
        super(document.getRootElement(), replacer);
    }

    @Override
    protected void reassignCurrentElement(Object current) {
        this.currentElement = (Element)current;
    }

    @Override
    protected Object getParent() {
        return this.currentElement.getParentElement();
    }

    @Override
    protected Object getChild(int index) {
        return this.currentElement.getChildren().get(index);
    }

    @Override
    protected int getChildCount() {
        return this.currentElement.getChildren().size();
    }

    @Override
    public String getNodeName() {
        return this.unescapeXmlName(this.currentElement.getName());
    }

    @Override
    public String getValue() {
        return this.currentElement.getText();
    }

    @Override
    public String getAttribute(String name) {
        return this.currentElement.getAttributeValue(name);
    }

    @Override
    public String getAttribute(int index) {
        return ((Attribute)this.currentElement.getAttributes().get(index)).getValue();
    }

    @Override
    public int getAttributeCount() {
        return this.currentElement.getAttributes().size();
    }

    @Override
    public String getAttributeName(int index) {
        return this.unescapeXmlName(((Attribute)this.currentElement.getAttributes().get(index)).getQualifiedName());
    }
}

