/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.StreamException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.JDomReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import org.jetbrains.jet.internal.org.jdom.Document;
import org.jetbrains.jet.internal.org.jdom.JDOMException;
import org.jetbrains.jet.internal.org.jdom.input.SAXBuilder;

public class JDomDriver
extends AbstractXmlDriver {
    public JDomDriver() {
        super(new XmlFriendlyReplacer());
    }

    public JDomDriver(XmlFriendlyReplacer replacer) {
        super(replacer);
    }

    @Override
    public HierarchicalStreamReader createReader(Reader reader) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(reader);
            return new JDomReader(document, this.xmlFriendlyReplacer());
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
        catch (JDOMException e) {
            throw new StreamException(e);
        }
    }

    @Override
    public HierarchicalStreamReader createReader(InputStream in) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(in);
            return new JDomReader(document, this.xmlFriendlyReplacer());
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
        catch (JDOMException e) {
            throw new StreamException(e);
        }
    }

    @Override
    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.xmlFriendlyReplacer());
    }

    @Override
    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return new PrettyPrintWriter(new OutputStreamWriter(out));
    }
}

