/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml;

import java.util.Iterator;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ErrorWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.FastStack;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.AttributeNameIterator;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.AbstractXmlReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.DocumentReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;

public abstract class AbstractDocumentReader
extends AbstractXmlReader
implements DocumentReader {
    private FastStack pointers = new FastStack(16);
    private Object current;

    protected AbstractDocumentReader(Object rootElement) {
        this(rootElement, new XmlFriendlyReplacer());
    }

    protected AbstractDocumentReader(Object rootElement, XmlFriendlyReplacer replacer) {
        super(replacer);
        this.current = rootElement;
        this.pointers.push(new Pointer());
        this.reassignCurrentElement(this.current);
    }

    protected abstract void reassignCurrentElement(Object var1);

    protected abstract Object getParent();

    protected abstract Object getChild(int var1);

    protected abstract int getChildCount();

    @Override
    public boolean hasMoreChildren() {
        Pointer pointer = (Pointer)this.pointers.peek();
        return pointer.v < this.getChildCount();
    }

    @Override
    public void moveUp() {
        this.current = this.getParent();
        this.pointers.popSilently();
        this.reassignCurrentElement(this.current);
    }

    @Override
    public void moveDown() {
        Pointer pointer = (Pointer)this.pointers.peek();
        this.pointers.push(new Pointer());
        this.current = this.getChild(pointer.v);
        ++pointer.v;
        this.reassignCurrentElement(this.current);
    }

    @Override
    public Iterator getAttributeNames() {
        return new AttributeNameIterator(this);
    }

    @Override
    public void appendErrors(ErrorWriter errorWriter) {
    }

    public Object peekUnderlyingNode() {
        return this.current;
    }

    @Override
    public Object getCurrent() {
        return this.current;
    }

    @Override
    public void close() {
    }

    @Override
    public HierarchicalStreamReader underlyingReader() {
        return this;
    }

    private static class Pointer {
        public int v;

        private Pointer() {
        }
    }
}

