/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ThreadSafeSimpleDateFormat {
    private final String formatString;
    private final int initialPoolSize;
    private final int maxPoolSize;
    private transient DateFormat[] pool;
    private transient int nextAvailable;
    private transient Object mutex = new Object();

    public ThreadSafeSimpleDateFormat(String format, int initialPoolSize, int maxPoolSize) {
        this.formatString = format;
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date) {
        DateFormat format = this.fetchFromPool();
        try {
            String string = format.format(date);
            return string;
        }
        finally {
            this.putInPool(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String date) throws ParseException {
        DateFormat format = this.fetchFromPool();
        try {
            Date date2 = format.parse(date);
            return date2;
        }
        finally {
            this.putInPool(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateFormat fetchFromPool() {
        DateFormat result;
        Object object = this.mutex;
        synchronized (object) {
            if (this.pool == null) {
                this.pool = new DateFormat[this.maxPoolSize];
                this.nextAvailable = this.initialPoolSize;
                while (this.nextAvailable > 0) {
                    this.putInPool(this.createNew());
                }
            }
            while (this.nextAvailable == this.maxPoolSize) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(new StringBuffer().append("Interrupted whilst waiting for a free item in the pool : ").append(e.getMessage()).toString());
                }
            }
            if ((result = this.pool[this.nextAvailable++]) == null) {
                result = this.createNew();
                this.putInPool(result);
                ++this.nextAvailable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInPool(DateFormat format) {
        Object object = this.mutex;
        synchronized (object) {
            this.pool[--this.nextAvailable] = format;
            this.mutex.notify();
        }
    }

    private DateFormat createNew() {
        return new SimpleDateFormat(this.formatString, Locale.ENGLISH);
    }
}

