/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.util.Map;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConversionException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.DataHolder;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.FastStack;

public class CustomObjectInputStream
extends ObjectInputStream {
    private FastStack callbacks = new FastStack(1);
    private static final String DATA_HOLDER_KEY = (class$com$thoughtworks$xstream$core$util$CustomObjectInputStream == null ? (class$com$thoughtworks$xstream$core$util$CustomObjectInputStream = CustomObjectInputStream.class$("org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.CustomObjectInputStream")) : class$com$thoughtworks$xstream$core$util$CustomObjectInputStream).getName();
    static /* synthetic */ Class class$com$thoughtworks$xstream$core$util$CustomObjectInputStream;

    public static synchronized CustomObjectInputStream getInstance(DataHolder whereFrom, StreamCallback callback) {
        try {
            CustomObjectInputStream result = (CustomObjectInputStream)whereFrom.get(DATA_HOLDER_KEY);
            if (result == null) {
                result = new CustomObjectInputStream(callback);
                whereFrom.put(DATA_HOLDER_KEY, result);
            } else {
                result.pushCallback(callback);
            }
            return result;
        }
        catch (IOException e) {
            throw new ConversionException("Cannot create CustomObjectStream", e);
        }
    }

    public CustomObjectInputStream(StreamCallback callback) throws IOException, SecurityException {
        this.callbacks.push(callback);
    }

    public void pushCallback(StreamCallback callback) {
        this.callbacks.push(callback);
    }

    public StreamCallback popCallback() {
        return (StreamCallback)this.callbacks.pop();
    }

    public StreamCallback peekCallback() {
        return (StreamCallback)this.callbacks.peek();
    }

    @Override
    public void defaultReadObject() throws IOException {
        this.peekCallback().defaultReadObject();
    }

    @Override
    protected Object readObjectOverride() throws IOException {
        return this.peekCallback().readFromStream();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return (Boolean)this.peekCallback().readFromStream();
    }

    @Override
    public byte readByte() throws IOException {
        return (Byte)this.peekCallback().readFromStream();
    }

    @Override
    public int readInt() throws IOException {
        return (Integer)this.peekCallback().readFromStream();
    }

    @Override
    public char readChar() throws IOException {
        return ((Character)this.peekCallback().readFromStream()).charValue();
    }

    @Override
    public float readFloat() throws IOException {
        return ((Float)this.peekCallback().readFromStream()).floatValue();
    }

    @Override
    public double readDouble() throws IOException {
        return (Double)this.peekCallback().readFromStream();
    }

    @Override
    public long readLong() throws IOException {
        return (Long)this.peekCallback().readFromStream();
    }

    @Override
    public short readShort() throws IOException {
        return (Short)this.peekCallback().readFromStream();
    }

    @Override
    public String readUTF() throws IOException {
        return (String)this.peekCallback().readFromStream();
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        byte[] b = (byte[])this.peekCallback().readFromStream();
        System.arraycopy(b, 0, buf, off, len);
    }

    @Override
    public ObjectInputStream.GetField readFields() throws IOException {
        return new CustomGetField(this.peekCallback().readFieldsFromStream());
    }

    @Override
    public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException, InvalidObjectException {
        this.peekCallback().registerValidation(validation, priority);
    }

    @Override
    public void close() throws IOException {
        this.peekCallback().close();
    }

    @Override
    public int available() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedByte() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object readUnshared() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedShort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] buf, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int skipBytes(int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CustomGetField
    extends ObjectInputStream.GetField {
        private Map fields;

        public CustomGetField(Map fields) {
            this.fields = fields;
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            throw new UnsupportedOperationException();
        }

        private Object get(String name) {
            return this.fields.get(name);
        }

        @Override
        public boolean defaulted(String name) {
            return !this.fields.containsKey(name);
        }

        @Override
        public byte get(String name, byte val) {
            return this.defaulted(name) ? val : (Byte)this.get(name);
        }

        @Override
        public char get(String name, char val) {
            return this.defaulted(name) ? val : ((Character)this.get(name)).charValue();
        }

        @Override
        public double get(String name, double val) {
            return this.defaulted(name) ? val : (Double)this.get(name);
        }

        @Override
        public float get(String name, float val) {
            return this.defaulted(name) ? val : ((Float)this.get(name)).floatValue();
        }

        @Override
        public int get(String name, int val) {
            return this.defaulted(name) ? val : (Integer)this.get(name);
        }

        @Override
        public long get(String name, long val) {
            return this.defaulted(name) ? val : (Long)this.get(name);
        }

        @Override
        public short get(String name, short val) {
            return this.defaulted(name) ? val : (Short)this.get(name);
        }

        @Override
        public boolean get(String name, boolean val) {
            return this.defaulted(name) ? val : (Boolean)this.get(name);
        }

        @Override
        public Object get(String name, Object val) {
            return this.defaulted(name) ? val : this.get(name);
        }
    }

    public static interface StreamCallback {
        public Object readFromStream() throws IOException;

        public Map readFieldsFromStream() throws IOException;

        public void defaultReadObject() throws IOException;

        public void registerValidation(ObjectInputValidation var1, int var2) throws NotActiveException, InvalidObjectException;

        public void close() throws IOException;
    }
}

