/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.core;

import java.util.Iterator;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.alias.ClassMapper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.Converter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConverterLookup;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.DataHolder;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.MarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.MapBackedDataHolder;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class TreeMarshaller
implements MarshallingContext {
    protected HierarchicalStreamWriter writer;
    protected ConverterLookup converterLookup;
    protected ClassMapper classMapper;
    private Mapper mapper;
    private ObjectIdDictionary parentObjects = new ObjectIdDictionary();
    private DataHolder dataHolder;

    public TreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
        this.writer = writer;
        this.converterLookup = converterLookup;
        this.mapper = mapper;
        if (mapper instanceof ClassMapper) {
            this.classMapper = (ClassMapper)mapper;
        }
    }

    public TreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, ClassMapper classMapper) {
        this(writer, converterLookup, (Mapper)classMapper);
    }

    @Override
    public void convertAnother(Object item) {
        Converter converter = this.converterLookup.lookupConverterForType(item.getClass());
        this.convert(item, converter);
    }

    @Override
    public void convertAnother(Object item, Converter converter) {
        this.convert(item, converter);
    }

    protected void convert(Object item, Converter converter) {
        if (this.parentObjects.containsId(item)) {
            throw new CircularReferenceException();
        }
        this.parentObjects.associateId(item, "");
        converter.marshal(item, this.writer, this);
        this.parentObjects.removeId(item);
    }

    public void start(Object item, DataHolder dataHolder) {
        this.dataHolder = dataHolder;
        if (item == null) {
            this.writer.startNode(this.mapper.serializedClass(null));
            this.writer.endNode();
        } else {
            ExtendedHierarchicalStreamWriterHelper.startNode(this.writer, this.mapper.serializedClass(item.getClass()), item.getClass());
            this.convertAnother(item);
            this.writer.endNode();
        }
    }

    @Override
    public Object get(Object key) {
        this.lazilyCreateDataHolder();
        return this.dataHolder.get(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.lazilyCreateDataHolder();
        this.dataHolder.put(key, value);
    }

    @Override
    public Iterator keys() {
        this.lazilyCreateDataHolder();
        return this.dataHolder.keys();
    }

    private void lazilyCreateDataHolder() {
        if (this.dataHolder == null) {
            this.dataHolder = new MapBackedDataHolder();
        }
    }

    protected Mapper getMapper() {
        return this.mapper;
    }

    public static class CircularReferenceException
    extends RuntimeException {
    }
}

