/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.core;

import org.jetbrains.jet.internal.com.thoughtworks.xstream.alias.ClassMapper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConverterLookup;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.AbstractReferenceUnmarshaller;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.path.Path;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.path.PathTracker;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.path.PathTrackingReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class ReferenceByXPathUnmarshaller
extends AbstractReferenceUnmarshaller {
    private PathTracker pathTracker = new PathTracker();

    public ReferenceByXPathUnmarshaller(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, Mapper mapper) {
        super(root, reader, converterLookup, mapper);
        this.reader = new PathTrackingReader(reader, this.pathTracker);
    }

    public ReferenceByXPathUnmarshaller(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, ClassMapper classMapper) {
        this(root, reader, converterLookup, (Mapper)classMapper);
    }

    @Override
    protected Object getReferenceKey(String reference) {
        Path path = new Path(reference);
        return reference.charAt(0) != '/' ? this.pathTracker.getPath().apply(path) : path;
    }

    @Override
    protected Object getCurrentReferenceKey() {
        return this.pathTracker.getPath();
    }
}

