/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.alias.ClassMapper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConversionException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.Converter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConverterLookup;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.PrioritizedList;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class DefaultConverterLookup
implements ConverterLookup {
    private final PrioritizedList converters = new PrioritizedList();
    private transient Map typeToConverterMap = Collections.synchronizedMap(new HashMap());
    private final Mapper mapper;

    public DefaultConverterLookup(Mapper mapper) {
        this.mapper = mapper;
    }

    public DefaultConverterLookup(ClassMapper classMapper) {
        this((Mapper)classMapper);
    }

    @Override
    public Converter lookupConverterForType(Class type) {
        Converter cachedConverter = (Converter)this.typeToConverterMap.get(type);
        if (cachedConverter != null) {
            return cachedConverter;
        }
        Class mapType = this.mapper.defaultImplementationOf(type);
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            Converter converter = (Converter)iterator.next();
            if (!converter.canConvert(mapType)) continue;
            this.typeToConverterMap.put(type, converter);
            return converter;
        }
        throw new ConversionException(new StringBuffer().append("No converter specified for ").append(type).toString());
    }

    public void registerConverter(Converter converter, int priority) {
        this.converters.add(converter, priority);
        Iterator iter = this.typeToConverterMap.keySet().iterator();
        while (iter.hasNext()) {
            Class type = (Class)iter.next();
            if (!converter.canConvert(type)) continue;
            iter.remove();
        }
    }
}

