/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.reflection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConversionException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.MarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.UnmarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.reflection.ReflectionProviderWrapper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class SerializableConverter
extends AbstractReflectionConverter {
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Object;

    public SerializableConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, new UnserializableParentsReflectionProvider(reflectionProvider));
    }

    @Override
    public boolean canConvert(Class type) {
        return this.isSerializable(type);
    }

    private boolean isSerializable(Class type) {
        return (class$java$io$Serializable == null ? (class$java$io$Serializable = SerializableConverter.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(type) && (this.serializationMethodInvoker.supportsReadObject(type, true) || this.serializationMethodInvoker.supportsWriteObject(type, true));
    }

    @Override
    public void doMarshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        writer.addAttribute("serialization", "custom");
        final Class[] currentType = new Class[1];
        final boolean[] writtenClassWrapper = new boolean[]{false};
        CustomObjectOutputStream.StreamCallback callback = new CustomObjectOutputStream.StreamCallback(){

            @Override
            public void writeToStream(Object object) {
                if (object == null) {
                    writer.startNode("null");
                    writer.endNode();
                } else {
                    ExtendedHierarchicalStreamWriterHelper.startNode(writer, SerializableConverter.this.mapper.serializedClass(object.getClass()), object.getClass());
                    context.convertAnother(object);
                    writer.endNode();
                }
            }

            @Override
            public void writeFieldsToStream(Map fields) {
                ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(currentType[0]);
                writer.startNode("default");
                for (String name : fields.keySet()) {
                    ObjectStreamField field = objectStreamClass.getField(name);
                    Object value = fields.get(name);
                    if (field == null) {
                        throw new ObjectAccessException(new StringBuffer().append("Class ").append(value.getClass().getName()).append(" may not write a field named '").append(name).append("'").toString());
                    }
                    if (value == null) continue;
                    writer.startNode(SerializableConverter.this.mapper.serializedMember(currentType[0], name));
                    if (field.getType() != value.getClass() && !field.getType().isPrimitive()) {
                        writer.addAttribute("class", SerializableConverter.this.mapper.serializedClass(value.getClass()));
                    }
                    context.convertAnother(value);
                    writer.endNode();
                }
                writer.endNode();
            }

            @Override
            public void defaultWriteObject() {
                boolean writtenDefaultFields = false;
                ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(currentType[0]);
                if (objectStreamClass == null) {
                    return;
                }
                ObjectStreamField[] fields = objectStreamClass.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    ObjectStreamField field = fields[i];
                    Object value = SerializableConverter.this.readField(field, currentType[0], source);
                    if (value == null) continue;
                    if (!writtenClassWrapper[0]) {
                        writer.startNode(SerializableConverter.this.mapper.serializedClass(currentType[0]));
                        writtenClassWrapper[0] = true;
                    }
                    if (!writtenDefaultFields) {
                        writer.startNode("default");
                        writtenDefaultFields = true;
                    }
                    writer.startNode(SerializableConverter.this.mapper.serializedMember(currentType[0], field.getName()));
                    Class<?> actualType = value.getClass();
                    Class defaultType = SerializableConverter.this.mapper.defaultImplementationOf(field.getType());
                    if (!actualType.equals(defaultType)) {
                        writer.addAttribute("class", SerializableConverter.this.mapper.serializedClass(actualType));
                    }
                    context.convertAnother(value);
                    writer.endNode();
                }
                if (writtenClassWrapper[0] && !writtenDefaultFields) {
                    writer.startNode("default");
                    writer.endNode();
                } else if (writtenDefaultFields) {
                    writer.endNode();
                }
            }

            @Override
            public void flush() {
                writer.flush();
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException("Objects are not allowed to call ObjectOutputStream.close() from writeObject()");
            }
        };
        try {
            boolean mustHandleUnserializableParent = false;
            Iterator classHieararchy = this.hierarchyFor(source.getClass()).iterator();
            while (classHieararchy.hasNext()) {
                currentType[0] = (Class)classHieararchy.next();
                if (!(class$java$io$Serializable == null ? SerializableConverter.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(currentType[0])) {
                    mustHandleUnserializableParent = true;
                    continue;
                }
                if (mustHandleUnserializableParent) {
                    this.marshalUnserializableParent(writer, context, source);
                    mustHandleUnserializableParent = false;
                }
                if (this.serializationMethodInvoker.supportsWriteObject(currentType[0], false)) {
                    writtenClassWrapper[0] = true;
                    writer.startNode(this.mapper.serializedClass(currentType[0]));
                    CustomObjectOutputStream objectOutputStream = CustomObjectOutputStream.getInstance(context, callback);
                    this.serializationMethodInvoker.callWriteObject(currentType[0], source, objectOutputStream);
                    objectOutputStream.popCallback();
                    writer.endNode();
                    continue;
                }
                if (this.serializationMethodInvoker.supportsReadObject(currentType[0], false)) {
                    writtenClassWrapper[0] = true;
                    writer.startNode(this.mapper.serializedClass(currentType[0]));
                    callback.defaultWriteObject();
                    writer.endNode();
                    continue;
                }
                writtenClassWrapper[0] = false;
                callback.defaultWriteObject();
                if (!writtenClassWrapper[0]) continue;
                writer.endNode();
            }
        }
        catch (IOException e) {
            throw new ObjectAccessException("Could not call defaultWriteObject()", e);
        }
    }

    private void marshalUnserializableParent(HierarchicalStreamWriter writer, MarshallingContext context, Object replacedSource) {
        writer.startNode("unserializable-parents");
        super.doMarshal(replacedSource, writer, context);
        writer.endNode();
    }

    private Object readField(ObjectStreamField field, Class type, Object instance) {
        try {
            Field javaField = type.getDeclaredField(field.getName());
            javaField.setAccessible(true);
            return javaField.get(instance);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectAccessException(new StringBuffer().append("Could not get field ").append(field.getClass()).append(".").append(field.getName()).toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException(new StringBuffer().append("Could not get field ").append(field.getClass()).append(".").append(field.getName()).toString(), e);
        }
        catch (NoSuchFieldException e) {
            throw new ObjectAccessException(new StringBuffer().append("Could not get field ").append(field.getClass()).append(".").append(field.getName()).toString(), e);
        }
        catch (SecurityException e) {
            throw new ObjectAccessException(new StringBuffer().append("Could not get field ").append(field.getClass()).append(".").append(field.getName()).toString(), e);
        }
    }

    protected List hierarchyFor(Class type) {
        ArrayList result = new ArrayList();
        while (type != (class$java$lang$Object == null ? SerializableConverter.class$("java.lang.Object") : class$java$lang$Object)) {
            result.add(type);
            type = type.getSuperclass();
        }
        Collections.reverse(result);
        return result;
    }

    @Override
    public Object doUnmarshal(final Object result, final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        final Class[] currentType = new Class[1];
        if (!"custom".equals(reader.getAttribute("serialization"))) {
            throw new ConversionException("Cannot deserialize object with new readObject()/writeObject() methods");
        }
        CustomObjectInputStream.StreamCallback callback = new CustomObjectInputStream.StreamCallback(){

            @Override
            public Object readFromStream() {
                reader.moveDown();
                Class type = SerializableConverter.this.mapper.realClass(reader.getNodeName());
                Object value = context.convertAnother(result, type);
                reader.moveUp();
                return value;
            }

            @Override
            public Map readFieldsFromStream() {
                HashMap<String, Object> fields = new HashMap<String, Object>();
                reader.moveDown();
                if (reader.getNodeName().equals("fields")) {
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (!reader.getNodeName().equals("field")) {
                            throw new ConversionException("Expected <field/> element inside <field/>");
                        }
                        String name = reader.getAttribute("name");
                        Class type = SerializableConverter.this.mapper.realClass(reader.getAttribute("class"));
                        Object value = context.convertAnother(result, type);
                        fields.put(name, value);
                        reader.moveUp();
                    }
                } else if (reader.getNodeName().equals("default")) {
                    ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(currentType[0]);
                    while (reader.hasMoreChildren()) {
                        Class<?> type;
                        reader.moveDown();
                        String name = reader.getNodeName();
                        String typeName = reader.getAttribute("class");
                        if (typeName != null) {
                            type = SerializableConverter.this.mapper.realClass(typeName);
                        } else {
                            ObjectStreamField field = objectStreamClass.getField(name);
                            if (field == null) {
                                throw new ObjectAccessException(new StringBuffer().append("Class ").append(currentType[0]).append(" does not contain a field named '").append(name).append("'").toString());
                            }
                            type = field.getType();
                        }
                        Object value = context.convertAnother(result, type);
                        fields.put(name, value);
                        reader.moveUp();
                    }
                } else {
                    throw new ConversionException("Expected <fields/> or <default/> element when calling ObjectInputStream.readFields()");
                }
                reader.moveUp();
                return fields;
            }

            @Override
            public void defaultReadObject() {
                if (!reader.hasMoreChildren()) {
                    return;
                }
                reader.moveDown();
                if (!reader.getNodeName().equals("default")) {
                    throw new ConversionException("Expected <default/> element in readObject() stream");
                }
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String fieldName = SerializableConverter.this.mapper.realMember(currentType[0], reader.getNodeName());
                    String classAttribute = reader.getAttribute("class");
                    Class type = classAttribute != null ? SerializableConverter.this.mapper.realClass(classAttribute) : SerializableConverter.this.mapper.defaultImplementationOf(SerializableConverter.this.reflectionProvider.getFieldType(result, fieldName, currentType[0]));
                    Object value = context.convertAnother(result, type);
                    SerializableConverter.this.reflectionProvider.writeField(result, fieldName, value, currentType[0]);
                    reader.moveUp();
                }
                reader.moveUp();
            }

            @Override
            public void registerValidation(final ObjectInputValidation validation, int priority) {
                context.addCompletionCallback(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            validation.validateObject();
                        }
                        catch (InvalidObjectException e) {
                            throw new ObjectAccessException(new StringBuffer().append("Cannot validate object : ").append(e.getMessage()).toString(), e);
                        }
                    }
                }, priority);
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException("Objects are not allowed to call ObjectInputStream.close() from readObject()");
            }
        };
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals("unserializable-parents")) {
                super.doUnmarshal(result, reader, context);
            } else {
                currentType[0] = this.mapper.defaultImplementationOf(this.mapper.realClass(nodeName));
                if (this.serializationMethodInvoker.supportsReadObject(currentType[0], false)) {
                    CustomObjectInputStream objectInputStream = CustomObjectInputStream.getInstance(context, callback);
                    this.serializationMethodInvoker.callReadObject(currentType[0], result, objectInputStream);
                    objectInputStream.popCallback();
                } else {
                    try {
                        callback.defaultReadObject();
                    }
                    catch (IOException e) {
                        throw new ObjectAccessException("Could not call defaultWriteObject()", e);
                    }
                }
            }
            reader.moveUp();
        }
        return result;
    }

    protected void doMarshalConditionally(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (this.isSerializable(source.getClass())) {
            this.doMarshal(source, writer, context);
        } else {
            super.doMarshal(source, writer, context);
        }
    }

    protected Object doUnmarshalConditionally(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        return this.isSerializable(result.getClass()) ? this.doUnmarshal(result, reader, context) : super.doUnmarshal(result, reader, context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class UnserializableParentsReflectionProvider
    extends ReflectionProviderWrapper {
        public UnserializableParentsReflectionProvider(ReflectionProvider reflectionProvider) {
            super(reflectionProvider);
        }

        @Override
        public void visitSerializableFields(Object object, final ReflectionProvider.Visitor visitor) {
            this.wrapped.visitSerializableFields(object, new ReflectionProvider.Visitor(){

                @Override
                public void visit(String name, Class type, Class definedIn, Object value) {
                    if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = SerializableConverter.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(definedIn)) {
                        visitor.visit(name, type, definedIn, value);
                    }
                }
            });
        }
    }
}

