/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.reflection;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.JVM;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.OrderRetainingMap;

public class FieldDictionary {
    private final Map keyedByFieldNameCache = Collections.synchronizedMap(new HashMap());
    private final Map keyedByFieldKeyCache = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$java$lang$Object;

    public Iterator serializableFieldsFor(Class cls) {
        return this.buildMap(cls, true).values().iterator();
    }

    public Field field(Class cls, String name, Class definedIn) {
        Map fields = this.buildMap(cls, definedIn != null);
        Field field = (Field)fields.get(definedIn != null ? new FieldKey(name, definedIn, 0) : name);
        if (field == null) {
            throw new ObjectAccessException(new StringBuffer().append("No such field ").append(cls.getName()).append(".").append(name).toString());
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildMap(Class cls, boolean tupleKeyed) {
        String clsName = cls.getName();
        if (!this.keyedByFieldNameCache.containsKey(clsName)) {
            Map map = this.keyedByFieldKeyCache;
            synchronized (map) {
                if (!this.keyedByFieldNameCache.containsKey(clsName)) {
                    HashMap<String, Field> keyedByFieldName = new HashMap<String, Field>();
                    OrderRetainingMap keyedByFieldKey = new OrderRetainingMap();
                    while (!(class$java$lang$Object == null ? FieldDictionary.class$("java.lang.Object") : class$java$lang$Object).equals(cls)) {
                        int i;
                        Field[] fields = cls.getDeclaredFields();
                        if (JVM.reverseFieldDefinition()) {
                            i = fields.length >> 1;
                            while (i-- > 0) {
                                int idx = fields.length - i - 1;
                                Field field = fields[i];
                                fields[i] = fields[idx];
                                fields[idx] = field;
                            }
                        }
                        for (i = 0; i < fields.length; ++i) {
                            Field field = fields[i];
                            field.setAccessible(true);
                            if (!keyedByFieldName.containsKey(field.getName())) {
                                keyedByFieldName.put(field.getName(), field);
                            }
                            keyedByFieldKey.put(new FieldKey(field.getName(), field.getDeclaringClass(), i), field);
                        }
                        cls = cls.getSuperclass();
                    }
                    this.keyedByFieldNameCache.put(clsName, keyedByFieldName);
                    this.keyedByFieldKeyCache.put(clsName, keyedByFieldKey);
                }
            }
        }
        return (Map)(tupleKeyed ? this.keyedByFieldKeyCache.get(clsName) : this.keyedByFieldNameCache.get(clsName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FieldKey {
        private String fieldName;
        private Class declaringClass;
        private Integer depth;
        private int order;

        public FieldKey(String fieldName, Class declaringClass, int order) {
            this.fieldName = fieldName;
            this.declaringClass = declaringClass;
            this.order = order;
            Class c = declaringClass;
            int i = 0;
            while (c.getSuperclass() != null) {
                ++i;
                c = c.getSuperclass();
            }
            this.depth = new Integer(i);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldKey)) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)o;
            if (this.declaringClass != null ? !this.declaringClass.equals(fieldKey.declaringClass) : fieldKey.declaringClass != null) {
                return false;
            }
            return !(this.fieldName != null ? !this.fieldName.equals(fieldKey.fieldName) : fieldKey.fieldName != null);
        }

        public int hashCode() {
            int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
            result = 29 * result + (this.declaringClass != null ? this.declaringClass.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new StringBuffer().append("FieldKey{order=").append(this.order).append(", writer=").append(this.depth).append(", declaringClass=").append(this.declaringClass).append(", fieldName='").append(this.fieldName).append("'").append("}").toString();
        }
    }
}

