/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.reflection;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputValidation;
import java.util.Map;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConversionException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.Converter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.MarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.UnmarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class ExternalizableConverter
implements Converter {
    private Mapper mapper;
    static /* synthetic */ Class class$java$io$Externalizable;

    public ExternalizableConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean canConvert(Class type) {
        return (class$java$io$Externalizable == null ? (class$java$io$Externalizable = ExternalizableConverter.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(type);
    }

    @Override
    public void marshal(Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        try {
            Externalizable externalizable = (Externalizable)source;
            CustomObjectOutputStream.StreamCallback callback = new CustomObjectOutputStream.StreamCallback(){

                @Override
                public void writeToStream(Object object) {
                    if (object == null) {
                        writer.startNode("null");
                        writer.endNode();
                    } else {
                        ExtendedHierarchicalStreamWriterHelper.startNode(writer, ExternalizableConverter.this.mapper.serializedClass(object.getClass()), object.getClass());
                        context.convertAnother(object);
                        writer.endNode();
                    }
                }

                @Override
                public void writeFieldsToStream(Map fields) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void defaultWriteObject() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void flush() {
                    writer.flush();
                }

                @Override
                public void close() {
                    throw new UnsupportedOperationException("Objects are not allowed to call ObjecOutput.close() from writeExternal()");
                }
            };
            CustomObjectOutputStream objectOutput = CustomObjectOutputStream.getInstance(context, callback);
            externalizable.writeExternal(objectOutput);
            objectOutput.popCallback();
        }
        catch (IOException e) {
            throw new ConversionException(new StringBuffer().append("Cannot serialize ").append(source.getClass().getName()).append(" using Externalization").toString(), e);
        }
    }

    @Override
    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        Class type = context.getRequiredType();
        try {
            final Externalizable externalizable = (Externalizable)type.newInstance();
            CustomObjectInputStream.StreamCallback callback = new CustomObjectInputStream.StreamCallback(){

                @Override
                public Object readFromStream() {
                    reader.moveDown();
                    Object streamItem = context.convertAnother(externalizable, ExternalizableConverter.this.mapper.realClass(reader.getNodeName()));
                    reader.moveUp();
                    return streamItem;
                }

                @Override
                public Map readFieldsFromStream() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void defaultReadObject() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException {
                    throw new NotActiveException("stream inactive");
                }

                @Override
                public void close() {
                    throw new UnsupportedOperationException("Objects are not allowed to call ObjectInput.close() from readExternal()");
                }
            };
            CustomObjectInputStream objectInput = CustomObjectInputStream.getInstance(context, callback);
            externalizable.readExternal(objectInput);
            objectInput.popCallback();
            return externalizable;
        }
        catch (InstantiationException e) {
            throw new ConversionException(new StringBuffer().append("Cannot construct ").append(type.getClass()).toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException(new StringBuffer().append("Cannot construct ").append(type.getClass()).toString(), e);
        }
        catch (IOException e) {
            throw new ConversionException(new StringBuffer().append("Cannot externalize ").append(type.getClass()).toString(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConversionException(new StringBuffer().append("Cannot externalize ").append(type.getClass()).toString(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

