/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.javabean;

import org.jetbrains.jet.internal.com.thoughtworks.xstream.alias.ClassMapper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConversionException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.Converter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.MarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.UnmarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.javabean.BeanProvider;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class JavaBeanConverter
implements Converter {
    private Mapper classMapper;
    private String classAttributeIdentifier;
    private BeanProvider beanProvider;

    public JavaBeanConverter(Mapper mapper, String classAttributeIdentifier) {
        this.classMapper = mapper;
        this.classAttributeIdentifier = classAttributeIdentifier;
        this.beanProvider = new BeanProvider();
    }

    public JavaBeanConverter(ClassMapper classMapper, String classAttributeIdentifier) {
        this((Mapper)classMapper, classAttributeIdentifier);
    }

    @Override
    public boolean canConvert(Class type) {
        return this.beanProvider.canInstantiate(type);
    }

    @Override
    public void marshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        this.beanProvider.visitSerializableProperties(source, new BeanProvider.Visitor(){

            @Override
            public void visit(String propertyName, Class fieldType, Object newObj) {
                if (newObj != null) {
                    this.writeField(propertyName, fieldType, newObj);
                }
            }

            private void writeField(String propertyName, Class fieldType, Object newObj) {
                ExtendedHierarchicalStreamWriterHelper.startNode(writer, JavaBeanConverter.this.classMapper.serializedMember(source.getClass(), propertyName), fieldType);
                Class<?> actualType = newObj.getClass();
                Class defaultType = JavaBeanConverter.this.classMapper.defaultImplementationOf(fieldType);
                if (!actualType.equals(defaultType)) {
                    writer.addAttribute(JavaBeanConverter.this.classAttributeIdentifier, JavaBeanConverter.this.classMapper.serializedClass(actualType));
                }
                context.convertAnother(newObj);
                writer.endNode();
            }
        });
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(context);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String propertyName = this.classMapper.realMember(result.getClass(), reader.getNodeName());
            boolean propertyExistsInClass = this.beanProvider.propertyDefinedInClass(propertyName, result.getClass());
            Class type = this.determineType(reader, result, propertyName);
            Object value = context.convertAnother(result, type);
            if (propertyExistsInClass) {
                this.beanProvider.writeProperty(result, propertyName, value);
            }
            reader.moveUp();
        }
        return result;
    }

    private Object instantiateNewInstance(UnmarshallingContext context) {
        Object result = context.currentObject();
        if (result == null) {
            result = this.beanProvider.newInstance(context.getRequiredType());
        }
        return result;
    }

    private Class determineType(HierarchicalStreamReader reader, Object result, String fieldName) {
        String classAttribute = reader.getAttribute(this.classAttributeIdentifier);
        if (classAttribute != null) {
            return this.classMapper.realClass(classAttribute);
        }
        return this.classMapper.defaultImplementationOf(this.beanProvider.getPropertyType(result, fieldName));
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
        }
    }
}

