/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.javabean;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.javabean.BeanProperty;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.javabean.PropertyDictionary;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;

public class BeanProvider {
    protected PropertyDictionary propertyDictionary = new PropertyDictionary();
    protected static final Object[] NO_PARAMS = new Object[0];

    public Object newInstance(Class type) {
        try {
            return this.getDefaultConstrutor(type).newInstance(NO_PARAMS);
        }
        catch (InstantiationException e) {
            throw new ObjectAccessException(new StringBuffer().append("Cannot construct ").append(type.getName()).toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException(new StringBuffer().append("Cannot construct ").append(type.getName()).toString(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new ObjectAccessException(new StringBuffer().append("Constructor for ").append(type.getName()).append(" threw an exception").toString(), e);
        }
    }

    public void visitSerializableProperties(Object object, Visitor visitor) {
        Iterator iterator = this.propertyDictionary.serializablePropertiesFor(object.getClass());
        while (iterator.hasNext()) {
            BeanProperty property = (BeanProperty)iterator.next();
            try {
                Object value = property.get(object);
                visitor.visit(property.getName(), property.getType(), value);
            }
            catch (IllegalArgumentException e) {
                throw new ObjectAccessException(new StringBuffer().append("Could not get property ").append(property.getClass()).append(".").append(property.getName()).toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException(new StringBuffer().append("Could not get property ").append(property.getClass()).append(".").append(property.getName()).toString(), e);
            }
        }
    }

    public void writeProperty(Object object, String propertyName, Object value) {
        BeanProperty property = this.propertyDictionary.property(object.getClass(), propertyName);
        try {
            property.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectAccessException(new StringBuffer().append("Could not set property ").append(object.getClass()).append(".").append(property.getName()).toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException(new StringBuffer().append("Could not set property ").append(object.getClass()).append(".").append(property.getName()).toString(), e);
        }
    }

    public Class getPropertyType(Object object, String name) {
        return this.propertyDictionary.property(object.getClass(), name).getType();
    }

    public boolean propertyDefinedInClass(String name, Class type) {
        return this.propertyDictionary.property(type, name) != null;
    }

    public boolean canInstantiate(Class type) {
        return this.getDefaultConstrutor(type) != null;
    }

    protected Constructor getDefaultConstrutor(Class type) {
        Constructor<?>[] constructors = type.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (c.getParameterTypes().length != 0 || !Modifier.isPublic(c.getModifiers())) continue;
            return c;
        }
        return null;
    }

    static interface Visitor {
        public void visit(String var1, Class var2, Object var3);
    }
}

