/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.extended;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConversionException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.Converter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.MarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.UnmarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class DynamicProxyConverter
implements Converter {
    private ClassLoader classLoader;
    private Mapper mapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$DynamicProxyMapper$DynamicProxy;

    public DynamicProxyConverter(Mapper mapper) {
        this(mapper, (class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter == null ? (class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter = DynamicProxyConverter.class$("org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.extended.DynamicProxyConverter")) : class$com$thoughtworks$xstream$converters$extended$DynamicProxyConverter).getClassLoader());
    }

    public DynamicProxyConverter(Mapper mapper, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.mapper = mapper;
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(class$com$thoughtworks$xstream$mapper$DynamicProxyMapper$DynamicProxy == null ? (class$com$thoughtworks$xstream$mapper$DynamicProxyMapper$DynamicProxy = DynamicProxyConverter.class$("org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.DynamicProxyMapper$DynamicProxy")) : class$com$thoughtworks$xstream$mapper$DynamicProxyMapper$DynamicProxy) || Proxy.isProxyClass(type);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(source);
        this.addInterfacesToXml(source, writer);
        writer.startNode("handler");
        writer.addAttribute("class", this.mapper.serializedClass(invocationHandler.getClass()));
        context.convertAnother(invocationHandler);
        writer.endNode();
    }

    private void addInterfacesToXml(Object source, HierarchicalStreamWriter writer) {
        Class<?>[] interfaces = source.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> currentInterface = interfaces[i];
            writer.startNode("interface");
            writer.setValue(this.mapper.serializedClass(currentInterface));
            writer.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        InvocationHandler handler = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String elementName = reader.getNodeName();
            if (elementName.equals("interface")) {
                interfaces.add(this.mapper.realClass(reader.getValue()));
            } else if (elementName.equals("handler")) {
                Class handlerType = this.mapper.realClass(reader.getAttribute("class"));
                handler = (InvocationHandler)context.convertAnother(null, handlerType);
            }
            reader.moveUp();
        }
        if (handler == null) {
            throw new ConversionException("No InvocationHandler specified for dynamic proxy");
        }
        Class[] interfacesAsArray = new Class[interfaces.size()];
        interfaces.toArray(interfacesAsArray);
        return Proxy.newProxyInstance(this.classLoader, interfacesAsArray, handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

