/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.enums;

import java.lang.reflect.Field;
import java.util.EnumMap;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.MarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.UnmarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.collections.MapConverter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.core.util.Fields;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class EnumMapConverter
extends MapConverter {
    private final Field typeField = Fields.find(EnumMap.class, "keyType");

    public EnumMapConverter(Mapper mapper) {
        super(mapper);
    }

    @Override
    public boolean canConvert(Class type) {
        return type == EnumMap.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Class type = (Class)Fields.read(this.typeField, source);
        writer.addAttribute(this.mapper().aliasForAttribute("enum-type"), this.mapper().serializedClass(type));
        super.marshal(source, writer, context);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class type = this.mapper().realClass(reader.getAttribute(this.mapper().aliasForAttribute("enum-type")));
        EnumMap map = new EnumMap(type);
        this.populateMap(reader, context, map);
        return map;
    }
}

