/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.collections;

import java.util.Comparator;
import java.util.TreeMap;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.ConversionException;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.MarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.UnmarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.collections.MapConverter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class TreeMapConverter
extends MapConverter {
    static /* synthetic */ Class class$java$util$TreeMap;

    public TreeMapConverter(Mapper mapper) {
        super(mapper);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(class$java$util$TreeMap == null ? (class$java$util$TreeMap = TreeMapConverter.class$("java.util.TreeMap")) : class$java$util$TreeMap);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TreeMap treeMap = (TreeMap)source;
        Comparator comparator = treeMap.comparator();
        if (comparator == null) {
            writer.startNode("no-comparator");
            writer.endNode();
        } else {
            writer.startNode("comparator");
            writer.addAttribute("class", this.mapper().serializedClass(comparator.getClass()));
            context.convertAnother(comparator);
            writer.endNode();
        }
        super.marshal(source, writer, context);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeMap result;
        reader.moveDown();
        if (reader.getNodeName().equals("comparator")) {
            String comparatorClass = reader.getAttribute("class");
            Comparator comparator = (Comparator)context.convertAnother(null, this.mapper().realClass(comparatorClass));
            result = new TreeMap(comparator);
        } else if (reader.getNodeName().equals("no-comparator")) {
            result = new TreeMap();
        } else {
            throw new ConversionException("TreeMap does not contain <comparator> element");
        }
        reader.moveUp();
        super.populateMap(reader, context, result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

