/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.MarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.UnmarshallingContext;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.jetbrains.jet.internal.com.thoughtworks.xstream.mapper.Mapper;

public class ArrayConverter
extends AbstractCollectionConverter {
    public ArrayConverter(Mapper mapper) {
        super(mapper);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.isArray();
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        int length = Array.getLength(source);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(source, i);
            this.writeItem(item, context, writer);
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Object> items = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Object item = this.readItem(reader, context, null);
            items.add(item);
            reader.moveUp();
        }
        Object array = Array.newInstance(context.getRequiredType().getComponentType(), items.size());
        int i = 0;
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            Array.set(array, i++, iterator.next());
        }
        return array;
    }
}

